
jQuery(document).ready(function($) {
    let previewData = null;
    
    // Preview button handler
    $("#preview-btn").on("click", function() {
        const formData = $("#arix-srp-form").serialize();
        
        $.ajax({
            url: arix_srp.ajax_url,
            type: "POST",
            data: {
                action: "arix_preview_results",
                nonce: arix_srp.nonce,
                ...$("#arix-srp-form").serializeArray().reduce((obj, item) => {
                    obj[item.name] = item.value;
                    return obj;
                }, {})
            },
            beforeSend: function() {
                $("#preview-results .arix-srp-preview-content").html(
                    '<div class="arix-srp-loading"><span class="spinner is-active"></span><p>' + arix_srp.processing_message + '</p></div>'
                );
                $("#replace-btn").prop("disabled", true);
            },
            success: function(response) {
                if (response.success) {
                    previewData = response.data;
                    let html = '<div class="arix-srp-preview-items">';
                    
                    if (response.data.length === 0) {
                        html += '<p>No matches found for your search criteria.</p>';
                    } else {
                        response.data.forEach(function(item) {
                            html += '<div class="arix-srp-preview-item">';
                            html += '<h3>' + item.title + ' <small>(' + item.type + ')</small></h3>';
                            html += '<p><strong>Original:</strong> ' + item.original_content + '</p>';
                            html += '<p><strong>Replaced:</strong> ' + item.replaced_content + '</p>';
                            html += '</div>';
                        });
                        html += '<p>Total matches found: ' + response.data.length + '</p>';
                    }
                    
                    html += '</div>';
                    $("#preview-results .arix-srp-preview-content").html(html);
                    $("#replace-btn").prop("disabled", false);
                } else {
                    $("#preview-results .arix-srp-preview-content").html('<p class="error">' + arix_srp.error_message + '</p>');
                }
            },
            error: function() {
                $("#preview-results .arix-srp-preview-content").html('<p class="error">' + arix_srp.error_message + '</p>');
            }
        });
    });
    
    // Replace button handler
    $("#arix-srp-form").on("submit", function(e) {
        e.preventDefault();
        
        if (!confirm(arix_srp.confirm_message)) {
            return;
        }
        
        $.ajax({
            url: arix_srp.ajax_url,
            type: "POST",
            data: {
                action: "arix_search_replace",
                nonce: arix_srp.nonce,
                ...$(this).serializeArray().reduce((obj, item) => {
                    obj[item.name] = item.value;
                    return obj;
                }, {})
            },
            beforeSend: function() {
                $("#replace-btn").prop("disabled", true).text(arix_srp.processing_message);
            },
            success: function(response) {
                if (response.success) {
                    alert(arix_srp.success_message + " " + response.data.message);
                    location.reload();
                } else {
                    alert(arix_srp.error_message);
                    $("#replace-btn").prop("disabled", false).text("Apply Changes");
                }
            },
            error: function() {
                alert(arix_srp.error_message);
                $("#replace-btn").prop("disabled", false).text("Apply Changes");
            }
        });
    });
    
    // Generate dummy content
    $("#generate-dummy").on("click", function() {
        if (!confirm("This will create sample pages, posts, and products. Continue?")) {
            return;
        }
        
        $.ajax({
            url: arix_srp.ajax_url,
            type: "POST",
            data: {
                action: "arix_generate_dummy_content",
                nonce: arix_srp.nonce
            },
            beforeSend: function() {
                $(this).prop("disabled", true).text("Generating...");
            },
            success: function(response) {
                if (response.success) {
                    alert(response.data);
                    location.reload();
                } else {
                    alert(arix_srp.error_message);
                    $("#generate-dummy").prop("disabled", false).text("Generate Sample Content");
                }
            },
            error: function() {
                alert(arix_srp.error_message);
                $("#generate-dummy").prop("disabled", false).text("Generate Sample Content");
            }
        });
    });
});
