<?php
/*
Template Name: Blog posts template
*/
get_header(); ?>

<?php get_template_part('heading_title');?>

<section class="blog_section">
<?php get_template_part('postcategories');?>
<div class="blog__dark">
<div class="container">

    <?php 

      $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;

      $custom_args = array(
          'post_type' => 'post',
          'posts_per_page' => 6,
          'paged' => $paged
        );

      $custom_query = new WP_Query( $custom_args ); ?>

      <?php if ( $custom_query->have_posts() ) : ?>

	<div class="blog_list flex">
        <!-- the loop -->
        <?php while ( $custom_query->have_posts() ) : $custom_query->the_post(); ?>
<article class="blog_item wow fadeIn lazyloaded" data-wow-delay=".07s" data-bg="" style="visibility: visible; background-image: url(&quot;data:image/svg+xml,%3Csvg%20xmlns=%22http://www.w3.org/2000/svg%22%20viewBox=%220%200%20500%20300%22%3E%3C/svg%3E&quot;); animation-delay: 0.07s; animation-name: fadeIn;"> 
<a href="<?php the_permalink(); ?>" class="blog_thumblink">
<div class="blog_item_thumb"> <?php if ( has_post_thumbnail() ) { 
the_post_thumbnail( get_the_ID(), 'full' );
} ?></div>
<div class="blog_item_cont-cat flex"> <span> <?php
 foreach((get_the_category()) as $category) {
 echo $category->cat_name . ' ';
 }
 ?> </span> <span class="time-read"><?php echo display_read_time(); ?></span></div>
<div class="blog_item_cont"><p class="blog_item-title"> <?php the_title(); ?></p></div>
<div class="blog_item_btn"><p>Read more</p></div> 
</a>
</article>
        <?php endwhile; ?>
        <!-- end of the loop -->
</div> 
        <!-- pagination here -->
        <?php
          if (function_exists('custom_pagination')) {
            custom_pagination($custom_query->max_num_pages,"",$paged);
          }
        ?>

      <?php wp_reset_postdata(); ?>

      <?php else:  ?>
 <p class = "no-blog-posts"><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
      <?php endif; ?>
</div>
</div>

</section>
    <?php get_footer(); ?>