<?php
function add_theme_scripts() {
    wp_enqueue_style( 'style', get_stylesheet_uri(), array(), null, 'all' );
}
add_action( 'wp_enqueue_scripts', 'add_theme_scripts' );
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );
add_filter( 'woocommerce_show_variation_price', '__return_true' );
add_filter( 'x_enqueue_parent_stylesheet', '__return_true' );

function our_theme_setup(){
    register_nav_menus(array(
        'pc__menu' => __('PC Menu'),
        'mobile__menu' => __('Mobile Menu'),
        'tg__menu' => __('Profile Menu'),
    ));
}
add_action('after_setup_theme','our_theme_setup');

function our_widget_init(){
    register_sidebar(array(
        'name' => 'Main Sidebar',
        'id' => 'main_sidebar',
        'before_title' => '<div class="widget-title">',
        'after_title' =>'</div>',
        'before_widget' => '<div class="catalog-widget-block">',
        'after_widget' => '</div>',
    ));
    register_sidebar(array(
        'name' => 'Blog Sidebar',
        'id' => 'blog_sidebar',
        'before_title' => '<p class="blog_sidebar_heading">',
        'after_title' =>'</p>',
        'before_widget' => '<div class="blog_sidebar_catalog">',
        'after_widget' => '</div>',
    ));
    register_sidebar(array(
        'name' => 'Footer Widgets Logo',
        'id' => 'footer_logo',
        'before_widget' => '<div class="widget">',
        'after_widget' => '</div>',
        'before_title' => '<p class="widget-title">',
        'after_title' =>'</p>',
    ));
    register_sidebar(array(
        'name' => 'Footer Widgets 1',
        'id' => 'footer_widgets1',
        'before_widget' => '<div class="widget">',
        'after_widget' => '</div>',
        'before_title' => '<p class="widget-title">',
        'after_title' =>'</p>',
    ));
    register_sidebar(array(
        'name' => 'Footer Widgets 2',
        'id' => 'footer_widgets2',
        'before_widget' => '<div class="widget">',
        'after_widget' => '</div>',
        'before_title' => '<p class="widget-title">',
        'after_title' =>'</p>',
    ));
    register_sidebar(array(
        'name' => 'Footer Widgets 3',
        'id' => 'footer_widgets3',
        'before_widget' => '<div class="widget">',
        'after_widget' => '</div>',
        'before_title' => '<p class="widget-title">',
        'after_title' =>'</p>',
    ));
}
add_action('widgets_init','our_widget_init');

// Thumbnail Images
add_theme_support('post-thumbnails');
add_theme_support('post-thumbnails', array('post', 'page', 'movie'));

function h420_custom_header_setup() {
    $args = array(
        'default-image'      => get_template_directory_uri() . '/img/default-image.jpg',
        'default-text-color' => '000',
        'width'              => 1000,
        'height'             => 250,
        'flex-width'         => true,
        'flex-height'        => true,
    );
    add_theme_support( 'custom-header', $args );
}
add_action( 'after_setup_theme', 'h420_custom_header_setup' );

function h420_add_woocommerce_support() {
    add_theme_support( 'woocommerce', array(
        'thumbnail_image_width' => 540,
        'single_image_width'    => 720,
        'product_grid'          => array(
            'default_rows'    => 3,
            'min_rows'        => 2,
            'max_rows'        => 8,
            'default_columns' => 4,
            'min_columns'     => 2,
            'max_columns'     => 5,
        ),
    ) );
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
}
add_action( 'after_setup_theme', 'h420_add_woocommerce_support' );

add_filter( 'h420_woocommerce_args', 'h420_resize_store_images' );
function h420_resize_store_images( $args ) {
    $args['single_image_width'] = 600;
    $args['thumbnail_image_width'] = 720;
    return $args;
}

add_theme_support( 'woocommerce', apply_filters( 'h420_woocommerce_args', array(
    'single_image_width' => 416,
    'thumbnail_image_width' => 324,
    'product_grid' => array(
        'default_columns' => 3,
        'default_rows' => 4,
        'min_columns' => 1,
        'max_columns' => 6,
        'min_rows' => 1
    )
)));

function custom_logo_setup() {
    $defaults = array(
        'height'               => 100,
        'width'                => 400,
        'flex-height'          => true,
        'flex-width'           => true,
        'header-text'          => array( 'site-title', 'site-description' ),
        'unlink-homepage-logo' => true,
    );
    add_theme_support( 'custom-logo', $defaults );
}
add_action( 'after_setup_theme', 'custom_logo_setup' ); // Fixed typo

function cc_mime_types($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

add_filter('jpeg_quality', function($arg){return 100;});

function wpbeginner_remove_comment_url($arg) {
    $arg['url'] = '';
    return $arg;
}

// Limited excerpt by character count
function get_excerpt( $count ) {
    $post = get_post();
    if ( ! $post ) return '';
    $permalink = get_permalink($post->ID);
    $excerpt = $post->post_content;
    $excerpt = strip_tags($excerpt);
    $excerpt = substr($excerpt, 0, $count);
    $excerpt = substr($excerpt, 0, strripos($excerpt, " "));
    $excerpt = '<p>'.$excerpt.'... </p>';
    return $excerpt;
}

function excerpt($limit) {
    $post = get_post();
    if ( ! $post ) return '';
    $text = $post->post_excerpt ?: wp_trim_words( $post->post_content, 55 );
    $excerpt = explode(' ', $text, $limit);
    if (count($excerpt) >= $limit) {
        array_pop($excerpt);
        $excerpt = implode(" ", $excerpt).'...';
    } else {
        $excerpt = implode(" ", $excerpt);
    }
    $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
    return $excerpt;
}

function content($limit) {
    $post = get_post();
    if ( ! $post ) return '';
    $text = apply_filters('the_content', $post->post_content);
    $content = explode(' ', $text, $limit);
    if (count($content) >= $limit) {
        array_pop($content);
        $content = implode(" ", $content).'...';
    } else {
        $content = implode(" ", $content);
    }
    $content = preg_replace('/\[.+\]/','', $content);
    $content = str_replace(']]>', ']]&gt;', $content);
    return $content;
}

add_shortcode('note', 'tt_test_note');
function tt_test_note($atts, $content = null) {
    ob_start();
    ?>
    <div class="note" style="margin: 30px 0; padding: 27px 40px; background: #fcf3dc; border-radius: 5px;">
        <p><?php echo esc_html($content); ?></p>
    </div>
    <?php
    return ob_get_clean();
}

function display_read_time() {
    $post = get_post();
    if ( ! $post ) return '';
    $content = $post->post_content;
    $count_words = str_word_count( strip_tags( $content ) );
    $read_time = ceil($count_words / 250);
    $prefix = '<span class="rt-prefix"> </span>';
    $suffix = '<span class="rt-suffix"> min read</span>';
    return $prefix . $read_time . $suffix;
}

function filter_theme_page_templates( $templates, $theme, $post ){
    if ( !empty( $post ) ){
        $post_type = get_post_type( $post->ID );
        switch( $post_type ){
            case 'custom-post-type':
                unset( $templates['page-template-filename.php'] );
                break;
            default:
                break;
        }
    }
    return $templates;
}
add_filter( 'theme_page_templates', 'filter_theme_page_templates', 10, 3 );

// HIGHLIGHTS Display Fields
add_action( 'woocommerce_product_options_general_product_data', 'woo_add_custom_fields2' );
add_action( 'woocommerce_process_product_meta', 'woo_add_custom_fields_save2' );

function woo_add_custom_fields2() {
    global $post;
    echo '<div class="single-prod-info-typecont">';
    woocommerce_wp_text_input(array(
        'id'          => 'Feelings_text_field',
        'label'       => __( 'Feelings:', 'woocommerce' ),
        'placeholder' => 'Feelings Tags',
        'desc_tip'    => 'true',
        'description' => __( 'Feelings', 'woocommerce' )
    ));
    woocommerce_wp_text_input(array(
        'id'          => 'Negatives_text_field',
        'label'       => __( 'Negatives', 'woocommerce' ),
        'placeholder' => 'Negatives Tags',
        'desc_tip'    => 'true',
        'description' => __( 'Negatives', 'woocommerce' )
    ));
    woocommerce_wp_text_input(array(
        'id'          => 'Helpswith_text_field',
        'label'       => __( 'Helps with', 'woocommerce' ),
        'placeholder' => 'Helps with Tags',
        'desc_tip'    => 'true',
        'description' => __( 'Helps with', 'woocommerce' )
    ));
    woocommerce_wp_text_input(array(
        'id'          => 'Calmorenergy_text_field',
        'label'       => __( 'Calm or Energy', 'woocommerce' ),
        'placeholder' => 'Calming and Energizing',
        'desc_tip'    => 'true',
        'description' => __( 'Calm or Energy', 'woocommerce' )
    ));
    woocommerce_wp_text_input(array(
        'id'          => 'Lthchthc_text_field',
        'label'       => __( 'Low/High THC', 'woocommerce' ),
        'placeholder' => 'Low thc High thc',
        'desc_tip'    => 'true',
        'description' => __( 'Low THC or High THC', 'woocommerce' )
    ));
    echo '</div>';
}

function woo_add_custom_fields_save2( $post_id ){
    if ( isset($_POST['Feelings_text_field']) ) {
        update_post_meta( $post_id, 'Feelings_text_field', sanitize_text_field($_POST['Feelings_text_field']) );
    }
    if ( isset($_POST['Negatives_text_field']) ) {
        update_post_meta( $post_id, 'Negatives_text_field', sanitize_text_field($_POST['Negatives_text_field']) );
    }
    if ( isset($_POST['Helpswith_text_field']) ) {
        update_post_meta( $post_id, 'Helpswith_text_field', sanitize_text_field($_POST['Helpswith_text_field']) );
    }
    if ( isset($_POST['Calmorenergy_text_field']) ) {
        update_post_meta( $post_id, 'Calmorenergy_text_field', sanitize_text_field($_POST['Calmorenergy_text_field']) );
    }
    if ( isset($_POST['Lthchthc_text_field']) ) {
        update_post_meta( $post_id, 'Lthchthc_text_field', sanitize_text_field($_POST['Lthchthc_text_field']) );
    }
}

add_action('woocommerce_product_meta_start', 'magik_custom_text' );
function magik_custom_text() {
    $post = get_post();
    if ( ! $post ) return;

    $feelings = get_post_meta( $post->ID, 'Feelings_text_field', true );
    $negatives = get_post_meta( $post->ID, 'Negatives_text_field', true );
    $helps = get_post_meta( $post->ID, 'Helpswith_text_field', true );
    $calm_energy = get_post_meta( $post->ID, 'Calmorenergy_text_field', true );
    $thc_level = get_post_meta( $post->ID, 'Lthchthc_text_field', true );

    if ( empty($feelings) && empty($negatives) && empty($helps) && empty($calm_energy) && empty($thc_level) ) {
        return;
    }

    echo '<div class="str-highlights" style="display:none;">
        <h2>STRAIN HIGHLIGHTS</h2>
        <div class="select-tag-list">
            <p class="select_tag_feel">Feelings:</p>
            <div>' . esc_html($feelings) . '</div>
        </div>
        <div class="select-tag-list">
            <p class="select_tag_neg">Negatives:</p>
            <div>' . esc_html($negatives) . '</div>
        </div>
        <div class="select-tag-list">
            <p class="select_tag_plus">Helps with:</p>
            <div>' . esc_html($helps) . '</div>
        </div>
        <div class="calm-or-energy">
            <div class="flex calm-or-energy-text">
                <p>Calming</p>
                <p>Energizing</p>
            </div>
            <div class="calm-or-energy-bg">
                <div class="calm-or-energy-fill" style="width: ' . esc_attr($calm_energy) . ';"></div>
            </div>
        </div>
        <div class="lthc_hthc">
            <div class="flex lthc_hthc-text">
                <p>Low THC</p>
                <p>High THC</p>
            </div>
            <div class="lthc_hthc-bg">
                <div class="lthc_hthc-fill" style="width: ' . esc_attr($thc_level) . ';"></div>
            </div>
        </div>
    </div>';
}

add_action( 'woocommerce_product_meta_start', 'add_custom_text_below_product_categories' );
function add_custom_text_below_product_categories() {
    global $product;
    if ( ! $product || ! $product->get_short_description() ) return;
    echo '<div class="woocommerce-product-details__short-description">' .
        apply_filters( 'woocommerce_short_description', $product->get_short_description() ) .
    '</div>';
}
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );

function woocommerce_template_single_excerpt() {
    return;
}

add_filter( 'woocommerce_redirect_single_search_result', '__return_false' );

add_filter( 'woocommerce_product_get_sku', 'bbloomer_variable_product_skus_admin', 9999, 2 );
function bbloomer_variable_product_skus_admin( $sku, $product ) {
    if ( ! is_admin() ) return $sku;
    global $post_type, $pagenow;
    if ( 'edit.php' === $pagenow && 'product' === $post_type ) {
        if ( $product->is_type('variable') ) {
            $sku = '';
            foreach ( $product->get_children() as $child_id ) {
                $variation = wc_get_product( $child_id );
                if ( $variation && $variation->exists() ) $sku .= '(' . $variation->get_sku() . ') ';
            }
        }
    }
    return $sku;
}

add_filter( 'woocommerce_product_add_to_cart_text', 'bbloomer_change_select_options_button_text', 9999, 2 );
function bbloomer_change_select_options_button_text( $label, $product ) {
    if ( $product && $product->is_type( 'variable' ) ) {
        return 'Select options';
    }
    return $label;
}

add_filter( 'woocommerce_product_add_to_cart_text', 'woocommerce_shop_page_add_to_cart_callback' );
function woocommerce_shop_page_add_to_cart_callback() {
    return __( 'Add to cart', 'text-domain' );
}

add_filter( 'woocommerce_product_single_add_to_cart_text', 'woocommerce_single_page_add_to_cart_callback' );
function woocommerce_single_page_add_to_cart_callback() {
    return __( 'Add to cart', 'text-domain' );
}

add_action( 'woocommerce_admin_order_data_after_order_details', 'cssigniter_add_admin_order_field' );
function cssigniter_add_admin_order_field( $order ){
    woocommerce_wp_text_input(array(
        'id'            => 'tracking_code',
        'label'         => __( 'Tracking code', 'your-text-domain' ),
        'value'         => get_post_meta( $order->get_id(), 'tracking_code', true ),
        'wrapper_class' => 'form-field-wide',
    ));
}

add_action( 'woocommerce_process_shop_order_meta', 'cssigniter_save_admin_order_field' );
function cssigniter_save_admin_order_field( $ord_id ) {
    if ( isset($_POST['tracking_code']) ) {
        update_post_meta( $ord_id, 'tracking_code', wc_clean( $_POST['tracking_code'] ) );
    }
}

add_filter( 'woocommerce_email_order_meta_fields', 'cssigniter_custom_order_email_fields', 10, 3 );
function cssigniter_custom_order_email_fields( $fields, $sent_to_admin, $order ) {
    $fields['tracking_code'] = array(
        'label' => __( 'Tracking Code', 'h420' ),
        'value' => get_post_meta( $order->get_id(), 'tracking_code', true ),
    );
    return $fields;
}

add_action( 'woocommerce_checkout_process', 'cssigniter_prevent_checkout_if_pending_payments' );
function cssigniter_prevent_checkout_if_pending_payments() {
    $customer = wp_get_current_user();
    if ( ! empty( $customer->ID ) ) {
        $args = array(
            'customer_id' => $customer->ID,
            'status'      => array( 'wc-pending' ),
        );
        $pending_orders = wc_get_orders( $args );
        if ( count( $pending_orders ) > 0 ) {
            $payment_links = array();
            foreach ( $pending_orders as $pending_order ) {
                $payment_links[] = '<a href="' . esc_url( $pending_order->get_checkout_payment_url() ) . '" target="_blank">#' . esc_html( $pending_order->get_order_number() ) . '</a>';
            }
            $payment_links = implode( ', ', $payment_links );
            $message = sprintf(
                __( 'Please take care of any outstanding payments from your <a href="%1$s" target="_blank">account page</a>, or the following links %2$s, before proceeding with new orders. Thank you.', 'hub420' ),
                esc_url( wc_get_page_permalink( 'myaccount' ) ),
                $payment_links
            );
            wc_add_notice( $message, 'error' );
        }
    }
}

add_action( 'woocommerce_checkout_process', 'cssigniter_set_minimum_order_amount' );
add_action( 'woocommerce_before_cart', 'cssigniter_set_minimum_order_amount' );
function cssigniter_set_minimum_order_amount() {
    $minimum = 50;
    if ( WC()->cart && WC()->cart->total < $minimum ) {
        if ( is_cart() ) {
            wc_print_notice(
                sprintf(
                    __( 'Your current order total is %1$s — you must have an order with a minimum of %2$s to place your order ', 'hub420' ),
                    wc_price( WC()->cart->total ),
                    wc_price( $minimum )
                ),
                'error'
            );
        } else {
            wc_add_notice(
                sprintf(
                    __( 'Your current order total is %1$s — you must have an order with a minimum of %2$s to place your order ', 'hub430' ),
                    wc_price( WC()->cart->total ),
                    wc_price( $minimum )
                ),
                'error'
            );
        }
    }
}

add_action( 'before_woocommerce_pay', 'bbloomer_order_pay_billing_address' );
function bbloomer_order_pay_billing_address() {
    if ( isset( $_GET['pay_for_order'], $_GET['key'] ) ) {
        $order_id = intval( basename( strtok( $_SERVER["REQUEST_URI"], '?' ) ) );
        $order = wc_get_order( $order_id );
        if ( $order ) {
            wc_get_template( 'order/order-details-customer.php', array( 'order' => $order ) );
        }
    }
}

add_action( 'woocommerce_thankyou', 'bbloomer_register_guests', 9999 );
function bbloomer_register_guests( $order_id ) {
    $order = wc_get_order( $order_id );
    if ( ! $order ) return;
    $email = $order->get_billing_email();
    if ( ! email_exists( $email ) && ! username_exists( $email ) ) {
        $customer_id = wc_create_new_customer( $email, '', '', array(
            'first_name' => $order->get_billing_first_name(),
            'last_name'  => $order->get_billing_last_name(),
        ));
        if ( ! is_wp_error( $customer_id ) ) {
            wc_update_new_customer_past_orders( $customer_id );
            wc_set_customer_auth_cookie( $customer_id );
        }
    } else {
        $user = get_user_by( 'email', $email );
        if ( $user ) {
            wc_update_new_customer_past_orders( $user->ID );
            wc_set_customer_auth_cookie( $user->ID );
        }
    }
}

add_filter( 'woocommerce_order_actions', 'bbloomer_show_thank_you_page_order_admin_actions', 9999, 2 );
function bbloomer_show_thank_you_page_order_admin_actions( $actions, $order ) {
    if ( $order->has_status( wc_get_is_paid_statuses() ) ) {
        $actions['view_thankyou'] = 'Display thank you page';
    }
    return $actions;
}

add_action( 'woocommerce_order_action_view_thankyou', 'bbloomer_redirect_thank_you_page_order_admin_actions' );
function bbloomer_redirect_thank_you_page_order_admin_actions( $order ) {
    $url = $order->get_checkout_order_received_url();
    add_filter( 'redirect_post_location', function() use ( $url ) {
        return $url;
    });
}

add_filter( 'the_content', 'misha_add_something_description_tab' );
function misha_add_something_description_tab( $content ){
    if( is_product() ) {
        $content .= '<p>&nbsp;</p><p><small>To find out more about our services please read our <a href="/faq/">FAQ section</a>.</small></p>
        <div class="product_meta"><div class="tagged_as"><p><small>Tags:</small></p><div class="product-catlist"><small> [product_tags]</small></div></div></div>';
    }
    return $content;
}

add_action('woocommerce_archive_description', 'custom_archive_description', 2 );
function custom_archive_description(){
    if( is_product_category() ) {
        add_action( 'woocommerce_after_main_content', 'woocommerce_taxonomy_archive_description', 10 );
    }
}

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
add_action( 'woocommerce_archive_description', 'woocommerceshop', 10 );
function woocommerceshop() {
    print do_shortcode ( '[wpf-filters id=3]' );
}

function wpseo_remove_home_breadcrumb($links) {
    if ( isset($links[0]) && $links[0]['url'] == home_url('/') ) {
        array_shift($links);
    }
    return $links;
}
add_filter('wpseo_breadcrumb_links', 'wpseo_remove_home_breadcrumb');

add_action( 'woocommerce_after_quantity_input_field', 'bbloomer_display_quantity_plus' );
function bbloomer_display_quantity_plus() {
    echo '<button type="button" class="plus quant-plus">+</button>';
}

add_action( 'woocommerce_before_quantity_input_field', 'bbloomer_display_quantity_minus' );
function bbloomer_display_quantity_minus() {
    echo '<button type="button" class="minus quant-minus">-</button>';
}

add_action( 'wp_footer', 'bbloomer_add_cart_quantity_plus_minus' );
function bbloomer_add_cart_quantity_plus_minus() {
    if ( ! is_product() && ! is_cart() ) return;
    wc_enqueue_js( "
    $(document).on( 'click', 'button.plus, button.minus', function() {
        var qty = $( this ).parent( '.quantity' ).find( '.qty' );
        var val = parseFloat(qty.val());
        var max = parseFloat(qty.attr( 'max' ));
        var min = parseFloat(qty.attr( 'min' ));
        var step = parseFloat(qty.attr( 'step' ));
        if ( $( this ).is( '.plus' ) ) {
            if ( max && ( max <= val ) ) {
                qty.val( max ).change();
            } else {
                qty.val( val + step ).change();
            }
        } else {
            if ( min && ( min >= val ) ) {
                qty.val( min ).change();
            } else if ( val > 1 ) {
                qty.val( val - step ).change();
            }
        }
    });
    " );
}

add_shortcode('product_tags', 'product_tags_per_product' );
function product_tags_per_product() {
    global $product;
    if ( ! $product ) return '';
    return '<div class="product-tags">' . wc_get_product_tag_list( $product->get_id(), ' ' ) . '</div>';
}

add_shortcode('product_category', 'product_category_per_product' );
function product_category_per_product() {
    global $product;
    if ( ! $product ) return '';
    return '<div class="product-catlist">' . wc_get_product_category_list( $product->get_id(), ' ' ) . '</div>';
}

// New Product Label Field
add_action( 'woocommerce_product_options_general_product_data', 'woo_add_custom_fields_new' );
add_action( 'woocommerce_process_product_meta', 'woo_add_custom_fields_new_save' );

function woo_add_custom_fields_new() {
    global $post;
    echo '<div class="options_group">';
    woocommerce_wp_text_input(array(
        'id'          => '_text_field_new',
        'label'       => __( 'New Product Label', 'woocommerce' ),
        'placeholder' => 'Enter your Product Label text here',
        'desc_tip'    => 'true',
        'description' => __( 'Enter your Product Label text here', 'woocommerce' )
    ));
    echo '</div>';
}

function woo_add_custom_fields_new_save( $post_id ){
    if ( isset($_POST['_text_field_new']) ) {
        update_post_meta( $post_id, '_text_field_new', sanitize_text_field($_POST['_text_field_new']) );
    }
}

// THC/CBD Display
add_action( 'woocommerce_product_options_general_product_data', 'woo_add_custom_fields1' );
add_action( 'woocommerce_process_product_meta', 'woo_add_custom_fields_save1' );

function woo_add_custom_fields1() {
    global $post;
    echo '<div class="single-prod-info-typecont">';
    woocommerce_wp_text_input(array(
        'id'          => 'THC_text_field',
        'label'       => __( 'THC:', 'woocommerce' ),
        'placeholder' => 'THC Percent',
        'desc_tip'    => 'true',
        'description' => __( 'THC', 'woocommerce' )
    ));
    woocommerce_wp_text_input(array(
        'id'          => 'CBD_text_field',
        'label'       => __( 'CBD:', 'woocommerce' ),
        'placeholder' => 'CBD Percent',
        'desc_tip'    => 'true',
        'description' => __( 'CBD', 'woocommerce' )
    ));
    echo '</div>';
}

function woo_add_custom_fields_save1( $post_id ){
    if ( isset($_POST['THC_text_field']) ) {
        update_post_meta( $post_id, 'THC_text_field', sanitize_text_field($_POST['THC_text_field']) );
    }
    if ( isset($_POST['CBD_text_field']) ) {
        update_post_meta( $post_id, 'CBD_text_field', sanitize_text_field($_POST['CBD_text_field']) );
    }
}

// Product Data Tab
function vnt_woo_product_data_tabs( $product_data_tabs ) {
    $product_data_tabs['vnt-data-tabs'] = array(
        'label'  => __( 'Data Tabs', 'vnthemes' ),
        'target' => 'vnt_data_tabs_option',
    );
    return $product_data_tabs;
}
add_filter( 'woocommerce_product_data_tabs', 'vnt_woo_product_data_tabs' , 1 , 1 );

function vnt_adv_product_options_field(){
    global $post;
    $product = wc_get_product( $post->ID );
    echo '<div id="vnt_data_tabs_option" class="panel woocommerce_options_panel">';
    woocommerce_wp_text_input(array(
        'id'            => 'vntp_label',
        'value'         => get_post_meta( $post->ID, 'vntp_label', true ),
        'label'         => __( 'THC Percent', 'woocommerce' ),
        'placeholder'   => 'THC...',
        'desc_tip'      => 'true',
        'wrapper_class' => ( $product && $product->is_type( 'variable' ) ) ? 'hide' : ''
    ));
    woocommerce_wp_checkbox(array(
        'id'            => 'vntp_topsale',
        'value'         => get_post_meta( $post->ID, 'vntp_topsale', true ),
        'label'         => 'Topsale label',
        'desc_tip'      => false,
        'wrapper_class' => ( $product && $product->is_type( 'variable' ) ) ? 'hide' : ''
    ));
    echo '</div>';
}
add_action( 'woocommerce_product_data_panels', 'vnt_adv_product_options_field');

// Shop Loop Title Customization
remove_action( 'woocommerce_shop_loop_item_title','woocommerce_template_loop_product_title', 10 );
function customize_shop_page_product_title() {
    global $product;
    if ( ! $product ) return;
    $average = $product->get_average_rating();
    echo '<div class="star-rating"><span style="width:0%"></span><span style="width:' . ( ( $average / 5 ) * 100 ) . '%"><strong itemprop="ratingValue" class="rating">' . esc_html($average) . '</strong> ' . __( 'out of 5', '__x__' ) . '</span></div>';
    echo '<div class="single-prod-info flex"><div class="single-prod-info-stars"></div><div class="single-prod-info-typecont"><div class="flex product-thccdb loop-thccdb"><div class="product-thc"><span class="product-thc-inf">THC: </span> ' . esc_html(get_post_meta( $product->get_id(), 'THC_text_field', true )) . '</div><div class="product-cbd"><span class="product-thc-inf">CBD: </span>' . esc_html(get_post_meta( $product->get_id(), 'CBD_text_field', true )) . '</div></div></div></div>';
}
add_action('woocommerce_shop_loop_item_title','customize_shop_page_product_title');

add_action( 'woocommerce_shop_loop_item_title', 'bbloomer_show_free_shipping_loop', 5 );
function bbloomer_show_free_shipping_loop() {
    echo '<p class="woocommerce-loop-product__title">' . get_the_title() . '</p>';
}

// Rating Field in Comments
add_action( 'comment_form_logged_in_after', 'ci_comment_rating_rating_field' );
add_action( 'comment_form_after_fields', 'ci_comment_rating_rating_field' );
function ci_comment_rating_rating_field () {
    ?>
    <label for="rating">Rating<span class="required">*</span></label>
    <fieldset class="comments-rating">
        <span class="rating-container">
            <?php for ( $i = 5; $i >= 1; $i-- ) : ?>
                <input type="radio" id="rating-<?php echo esc_attr( $i ); ?>" name="rating" value="<?php echo esc_attr( $i ); ?>" /><label for="rating-<?php echo esc_attr( $i ); ?>"><?php echo esc_html( $i ); ?></label>
            <?php endfor; ?>
            <input type="radio" id="rating-0" class="star-cb-clear" name="rating" value="0" /><label for="rating-0">0</label>
        </span>
    </fieldset>
    <?php
}

// Remove tabs
add_filter( 'woocommerce_product_tabs', 'my_remove_product_tabs', 98 );
function my_remove_product_tabs( $tabs ) {
    unset( $tabs['additional_information'] );
    return $tabs;
}

add_filter( 'wc_product_sku_enabled', '__return_true' ); // Keep SKU enabled unless you want to disable it
add_filter( 'woocommerce_product_description_heading', '__return_null' );

// Variation Radio Buttons
add_filter('woocommerce_dropdown_variation_attribute_options_html', 'variation_radio_buttons', 20, 2);
function variation_radio_buttons($html, $args) {
    $args = wp_parse_args(apply_filters('woocommerce_dropdown_variation_attribute_options_args', $args), array(
        'options'          => false,
        'attribute'        => false,
        'product'          => false,
        'selected'         => false,
        'name'             => '',
        'id'               => '',
        'class'            => '',
        'show_option_none' => __('Choose an option', 'woocommerce'),
    ));

    if ( false === $args['selected'] && $args['attribute'] && $args['product'] instanceof WC_Product ) {
        $selected_key = 'attribute_' . sanitize_title($args['attribute']);
        $args['selected'] = isset($_REQUEST[$selected_key]) ? wc_clean(wp_unslash($_REQUEST[$selected_key])) : $args['product']->get_variation_default_attribute($args['attribute']);
    }

    $options = $args['options'];
    $product = $args['product'];
    $attribute = $args['attribute'];
    $name = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title($attribute);
    $id = $args['id'] ? $args['id'] : sanitize_title($attribute);
    $class = $args['class'];
    $show_option_none = (bool)$args['show_option_none'];

    if ( empty($options) && !empty($product) && !empty($attribute) ) {
        $attributes = $product->get_variation_attributes();
        $options = $attributes[$attribute];
    }

    $radios = '<div class="variation-radios">';
    if ( !empty($options) ) {
        if ( $product && taxonomy_exists($attribute) ) {
            $terms = wc_get_product_terms($product->get_id(), $attribute, array('fields' => 'all'));
            foreach ( $terms as $term ) {
                if ( in_array($term->slug, $options, true) ) {
                    $field_id = $name . '-' . $term->slug;
                    $checked = checked( sanitize_title($args['selected']), $term->slug, false );
                    $radios .= '<input type="radio" id="' . esc_attr($field_id) . '" name="' . esc_attr($name) . '" value="' . esc_attr($term->slug) . '" ' . $checked . '><label for="' . esc_attr($field_id) . '">' . esc_html(apply_filters('woocommerce_variation_option_name', $term->name)) . '</label>';
                }
            }
        } else {
            foreach ( $options as $option ) {
                $field_id = $name . '-' . $option;
                $checked = sanitize_title($args['selected']) === $args['selected'] ? checked($args['selected'], sanitize_title($option), false) : checked($args['selected'], $option, false);
                $radios .= '<input type="radio" id="' . esc_attr($field_id) . '" name="' . esc_attr($name) . '" value="' . esc_attr($option) . '" ' . $checked . '><label for="' . esc_attr($field_id) . '">' . esc_html(apply_filters('woocommerce_variation_option_name', $option)) . '</label>';
            }
        }
    }
    $radios .= '</div>';
    return $html . $radios;
}

// Hide Price Range
add_filter( 'woocommerce_variable_sale_price_html', 'lw_variable_product_price', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 'lw_variable_product_price', 10, 2 );
function lw_variable_product_price( $v_price, $v_product ) {
    $min_price = $v_product->get_variation_price( 'min', true );
    $max_price = $v_product->get_variation_price( 'max', true );
    if ( $min_price !== $max_price ) {
        return sprintf( __('<span class="price-from">From:</span> %s', 'woocommerce'), wc_price( $min_price ) );
    } else {
        return wc_price( $min_price );
    }
}

add_action( 'woocommerce_before_single_product', 'move_variations_single_price', 1 );
function move_variations_single_price(){
    global $product;
    if ( $product && $product->is_type( 'variable' ) ) {
        add_action( 'woocommerce_single_product_summary', 'replace_variation_single_price', 10 );
    }
}

function replace_variation_single_price() {
    ?>
    <style>.woocommerce-variation-price { display: none; }</style>
    <script>
    jQuery(document).ready(function($) {
        var priceselector = '.product p.price';
        var originalprice = $(priceselector).html();
        $(document).on('show_variation', function() {
            $(priceselector).html($('.single_variation .woocommerce-variation-price').html());
        });
        $(document).on('hide_variation', function() {
            $(priceselector).html(originalprice);
        });
    });
    </script>
    <?php
}

function woocommerce_variable_add_to_cart() {
    global $product;
    if ( ! $product ) return;
    wp_enqueue_script( 'wc-add-to-cart-variation' );
    $get_variations = count( $product->get_children() ) <= apply_filters( 'woocommerce_ajax_variation_threshold', 30, $product );
    wc_get_template(
        'single-product/add-to-cart/variable.php',
        array(
            'available_variations' => $get_variations ? $product->get_available_variations() : false,
            'attributes'           => $product->get_variation_attributes(),
            'selected_attributes'  => $product->get_default_attributes(),
        )
    );
}

// Add price to variation dropdown
add_filter( 'woocommerce_variation_option_name', 'display_price_in_variation_option_name' );
function display_price_in_variation_option_name( $term ) {
    global $product;
    if ( empty( $term ) || ! $product ) return $term;
    $id = $product->get_id();
    global $wpdb;
    $result = $wpdb->get_col( $wpdb->prepare( "SELECT slug FROM {$wpdb->prefix}terms WHERE name = %s", $term ) );
    $term_slug = !empty( $result ) ? $result[0] : $term;
    $query = $wpdb->prepare(
        "SELECT postmeta.post_id AS product_id
        FROM {$wpdb->prefix}postmeta AS postmeta
        LEFT JOIN {$wpdb->prefix}posts AS products ON ( products.ID = postmeta.post_id )
        WHERE postmeta.meta_key LIKE 'attribute_%%'
        AND postmeta.meta_value = %s
        AND products.post_parent = %d",
        $term_slug, $id
    );
    $variation_ids = $wpdb->get_col( $query );
    if ( ! empty( $variation_ids[0] ) ) {
        $variation = wc_get_product( $variation_ids[0] );
        if ( $variation ) {
            return $term . ' ' . wp_kses( wc_price( $variation->get_price() ), array() );
        }
    }
    return $term;
}

// Grey out out-of-stock variations
add_filter( 'woocommerce_variation_is_active', 'ace_grey_out_variations_when_out_of_stock', 10, 2 );
function ace_grey_out_variations_when_out_of_stock( $is_active, $variation ) {
    if ( ! $variation->is_in_stock() ) {
        return false;
    }
    return $is_active;
}

add_action( 'wp_enqueue_scripts', 'ace__add_text_out_of_stock_variations' );
function ace__add_text_out_of_stock_variations() {
    wp_add_inline_script( 'wc-add-to-cart-variation', "
    jQuery('.variations_form').on('woocommerce_update_variation_values', function() {
        var outOfStockText = ' (out of stock)';
        jQuery(this).find('option:disabled').each(function() {
            var txt = jQuery(this).text();
            if (!txt.includes(outOfStockText)) {
                jQuery(this).text(txt + outOfStockText);
            }
        });
    });
    " );
}

// Search shortcode
add_shortcode('my_search_code', 'wpb_search_shortcode');
function wpb_search_shortcode() {
    ?>
    <div class="container search-sec">
        <div class="search-container">
            <div class="dgwt-wcas-search-wrapp dgwt-wcas-no-submit woocommerce dgwt-wcas-style-solaris js-dgwt-wcas-layout-classic dgwt-wcas-layout-classic js-dgwt-wcas-mobile-overlay-enabled">
                <?php echo do_shortcode('[fibosearch layout="icon"]'); ?>
            </div>
        </div>
    </div>
    <script>
    jQuery(function($) {
        $('.search-button').on('click', function() {
            $('.search-container').siblings().removeClass('active').end().toggleClass('active');
            $('.search-button').not(this).removeClass('active');
            $(this).toggleClass('active');
        });
    });
    </script>
    <?php
}

// Schema priceValidUntil
add_filter( 'wpseo_schema_product', 'gbol_reset_price_valid_until' );
function gbol_reset_price_valid_until( $data ) {
    if ( ! empty( $data['offers'] ) ) {
        foreach ( $data['offers'] as $key => $offer ) {
            if ( ! isset( $offer['priceValidUntil'] ) ) {
                $data['offers'][$key]['priceValidUntil'] = date( 'Y-12-31', time() + YEAR_IN_SECONDS );
            }
        }
    }
    return $data;
}

// Admin CSS
add_action( 'admin_head', 'admin_css' );
function admin_css() {
    echo "<style type='text/css'>.components-surface {display: none;}</style>";
}

// Custom sorting
add_filter( 'woocommerce_get_catalog_ordering_args', 'custom_woocommerce_get_catalog_ordering_args' );
function custom_woocommerce_get_catalog_ordering_args( $args ) {
    $orderby_value = isset( $_GET['orderby'] ) ? wc_clean( $_GET['orderby'] ) : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
    if ( 'random_list' == $orderby_value ) {
        $args['orderby'] = 'rand';
        $args['order'] = '';
        $args['meta_key'] = '';
    }
    return $args;
}

add_filter( 'woocommerce_default_catalog_orderby_options', 'custom_woocommerce_catalog_orderby' );
add_filter( 'woocommerce_catalog_orderby', 'custom_woocommerce_catalog_orderby' );
function custom_woocommerce_catalog_orderby( $sortby ) {
    $sortby['onsale'] = 'Discount';
    return $sortby;
}

// Email content
add_action( 'woocommerce_email_before_order_table', 'bbloomer_add_content_specific_email', 20, 4 );
function bbloomer_add_content_specific_email( $order, $sent_to_admin, $plain_text, $email ) {
    if ( $email->id == 'customer_on_hold_order' ) {
        echo '<h2 class="email-upsell-title">Get 10% off</h2><p class="email-upsell-p">Thank you for making this purchase! Come back and use the code "<strong>NEXTORDER</strong>" to receive a 10% discount on your next purchase! Click here to continue shopping.</p>';
    }
}

// Custom order status email
add_action( 'woocommerce_order_status_refused', 'bbloomer_status_custom_notification', 20, 2 );
function bbloomer_status_custom_notification( $order_id, $order ) {
    $heading = $subject = 'Order Refused';
    $mailer = WC()->mailer()->get_emails();
    if ( isset( $mailer['WC_Email_Customer_Completed_Order'] ) ) {
        $mailer['WC_Email_Customer_Completed_Order']->heading = $heading;
        $mailer['WC_Email_Customer_Completed_Order']->subject = $subject;
        $mailer['WC_Email_Customer_Completed_Order']->trigger( $order_id );
    }
}

// Prevent modified date update
add_filter( 'wp_insert_post_data', 'do_not_update_modified_date', 10, 2 );
function do_not_update_modified_date( $data, $postarr ) {
    if ( isset($data['post_modified']) && isset($data['post_modified_gmt']) &&
         isset($postarr['post_modified']) && isset($postarr['post_modified_gmt']) ) {
        $data['post_modified'] = $postarr['post_modified'];
        $data['post_modified_gmt'] = $postarr['post_modified_gmt'];
    }
    return $data;
}

// Product Subtitle
function wcsuccess_add_subtitle_field() {
    woocommerce_wp_text_input( array(
        'id' => '_product_subtitle',
        'label' => __( 'Product Subtitle', 'woocommerce' ),
        'placeholder' => 'Enter product subtitle here',
        'description' => __( 'Add a subtitle that will display below the product title.', 'woocommerce' ),
        'desc_tip' => true
    ));
}
add_action( 'woocommerce_product_options_general_product_data', 'wcsuccess_add_subtitle_field' );

function wcsuccess_save_subtitle_field( $post_id ) {
    $subtitle = isset( $_POST['_product_subtitle'] ) ? sanitize_text_field( $_POST['_product_subtitle'] ) : '';
    update_post_meta( $post_id, '_product_subtitle', $subtitle );
}
add_action( 'woocommerce_process_product_meta', 'wcsuccess_save_subtitle_field' );

function wcsuccess_display_product_subtitle() {
    global $product;
    if ( ! $product ) return;
    $subtitle = get_post_meta( $product->get_id(), '_product_subtitle', true );
    if ( ! empty( $subtitle ) ) {
        echo '<h2 class="product-subtitle" style="font-size: 16px; font-weight: normal; color: #555;">' . esc_html( $subtitle ) . '</h2>';
    }
}
add_action( 'woocommerce_single_product_summary', 'wcsuccess_display_product_subtitle', 6 );

add_action( 'woocommerce_after_shop_loop_item_title', 'custom_after_title' );
function custom_after_title() {
    global $product;
    if ( $product && $product->get_sku() ) {
        echo esc_html( $product->get_sku() );
    }
}