<style>
@charset "UTF-8";
@import url(https://fonts.googleapis.com/css?family=Nunito:400,300,700);
* {
  -webkit-font-smoothing: antialiased;
  -moz-osx-font-smoothing: grayscale;
  box-sizing: border-box;
}

body {
  background-color: #0b0b0b;
  font-family: "Nunito", sans-serif;
}

nav {
  position: fixed;
  z-index: 999;
  width: 100%;
  height: 70px;
  background-color: #ffffff;
  line-height: 70px;
}
nav .mini {
  position: fixed;
  top: 80px;
  right: 10px;
  background: #FFF;
  padding: 40px;
  opacity: 0;
  visibility: hidden;
  transition: opacity 0.2s ease 0.2s;
}
nav .mini.visible {
  padding: 40px;
  opacity: 1;
  visibility: visible;
}
nav .mini .products {
  font-weight: bold;
  font-size: 14px;
}
nav .mini p {
  font-size: 11px;
  display: block;
  margin: 0;
  padding: 0;
  line-height: 20px;
}
nav .cart {
  position: relative;
  float: right;
  margin-right: 50px;
  height: 20px;
  line-height: 70px;
  font-size: 28px;
  height: 100%;
  cursor: pointer;
}
nav .cart span {
  height: 100%;
  float: left;
  margin-right: 20px;
  opacity: 1;
  color: #fff;
  font-size: 18px;
  font-family: "Nunito", sans-serif;
}
nav .cart span.updateQuantity:before, nav .cart span.updateQuantity:after {
  top: 0;
  bottom: 0;
  opacity: 1;
  width: 30px;
  transition: all 0.2s ease, top 0.3s ease 0.4s, bottom 0.3s ease 0.4s;
}
nav .cart span.update {
  transition: color 0.2s ease 0.6s;
  color: #000;
}
nav .cart span.update:before {
  top: -30px;
  width: 30px;
  opacity: 1;
  transition: all 0.2s ease, top 0.3s ease 0.4s, bottom 0.3s ease 0.4s;
}
nav .cart span.update:after {
  top: 30px;
  width: 30px;
  opacity: 1;
  transition: all 0.2s ease, top 0.3s ease 0.4s, bottom 0.3s ease 0.4s;
}
nav .cart span:before, nav .cart span:after {
  content: "";
  position: absolute;
  width: 0px;
  height: 2px;
  background-color: #0b0b0b;
  left: -10px;
  right: 40px;
  top: 2px;
  bottom: 0;
  margin: auto;
}
nav ul {
  float: left;
}
nav ul li {
  font-weight: bold;
  display: inline-block;
  margin-left: 50px;
  color: #0b0b0b;
  font-size: 12px;
}

.container {
  padding: 20px;
  padding-top: 100px;
  text-align: center;
}
.container .product {
  position: relative;
  overflow: hidden;
  width: 200px;
  height: 240px;
  display: inline-block;
  border-radius: 4px;
  background-color: rgba(255, 255, 255, 0.45);
  margin: 20px;
  padding: 15px;
}
.container .product img {
  position: relative;
  top: -15px;
  left: -15px;
  transition: all 0.2s ease;
  -webkit-clip-path: polygon(0 100%, 0 0, 100% 0, 100% 70%);
          clip-path: polygon(0 100%, 0 0, 100% 0, 100% 70%);
  border-top-right-radius: 4px;
  border-top-left-radius: 4px;
}
.container .product img:hover {
  -webkit-clip-path: polygon(0 100%, 0 0, 100% 0, 100% 100%);
          clip-path: polygon(0 100%, 0 0, 100% 0, 100% 100%);
  transform: scale(1.1);
}
.container .product h2 {
  text-align: left;
  color: #fff;
  font-size: 14px;
  font-weight: bold;
  margin-bottom: 4px;
}
.container .product .description {
  text-align: left;
  font-size: 11px;
  color: #fff;
  max-height: 23px;
  overflow: hidden;
}
.container .product .price {
  text-align: right;
  font-size: 18px;
  color: #fff;
  margin-top: 6px;
}
.container .product .btn {
  position: absolute;
  font-size: 11px;
  font-weight: bold;
  float: right;
  padding: 10px;
  border: 2px solid #00fefe;
  border-radius: 20px;
  bottom: 10px;
  right: 10px;
  color: #00fefe;
  cursor: pointer;
  overflow: hidden;
  transition: all 0.2s ease;
}
.container .product .btn.ok {
  background-color: rgba(0, 254, 254, 0.4);
  color: #fff;
}
.container .product .btn.ok:after {
  content: "";
  color: #fff;
}
.container .product .btn:hover {
  padding-right: 25px;
}
.container .product .btn:hover:after {
  margin-left: 5px;
}
.container .product .btn:after {
  font-family: "simple-line-icons";
  content: "";
  transition: all 0.2s ease;
  position: absolute;
  color: #00fefe;
  margin-left: 30px;
  transition: all 0.2s ease;
}
.container .product .quickview {
  position: absolute;
  bottom: 20px;
  font-size: 11px;
  color: #fff;
  cursor: pointer;
}
.container .product .quickview:before {
  font-family: "simple-line-icons";
  content: "";
  margin-right: 3px;
}

.quickviewContainer {
  position: fixed;
  height: 100vh;
  width: 400px;
  background: rgba(0, 0, 0, 0.9);
  top: 70px;
  right: -100%;
  transition: all 0.3s ease;
  padding: 30px;
  color: #fff;
}
.quickviewContainer .close {
  height: 20px;
  width: 20px;
  float: right;
  cursor: pointer;
}
.quickviewContainer .close:before, .quickviewContainer .close:after {
  content: "";
  position: absolute;
  width: 20px;
  height: 2px;
  background-color: #ffF;
  transform: rotate(45deg);
}
.quickviewContainer .close:after {
  transform: rotate(-45deg);
}
.quickviewContainer .headline {
  margin-bottom: 30px;
  font-size: 18px;
}
.quickviewContainer .description {
  font-size: 12px;
  margin-bottom: 20px;
}
.quickviewContainer img {
  display: inline-block;
  border-radius: 4px;
  margin: 5px;
}
.quickviewContainer.active {
  right: 0;
}
</style>

<nav>
  <div class='mini'>
    <p class='products'>Empty</p>
    <p class='names'></p>
    <p class='miniprice'></p>
  </div>
  <ul>
    <li>Home</li>
    <li>Webshop</li>
    <li>Contact</li>
  </ul>
  <div class='cart icon-basket'>
    <span class='number'>1</span>
  </div>
</nav>
<div class='container'>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
  <div class='product'>
    <img src='https://placeimg.com/200/100'>
    <h2 class='header'>Product Name</h2>
    <p class='description'>Nullam posuere turpis vel lacinia luctus. Donec in efficitur neque. Curabitur consectetur non ipsum in eleifend. Praesent id velit in nisi maximus porta nec vitae odio. Proin vitae magna a massa accumsan venenatis. Donec semper, sem in ullamcorper bibendum, mauris sem imperdiet lorem, tempor aliquet ligula lorem sit amet nibh. Suspendisse potenti.</p>
    <p class='price'>231,-</p>
    <div class='btn'>Add to cart</div>
    <div class='quickview'>Quickview</div>
  </div>
</div>
<div class='quickviewContainer'>
  <div class='close'></div>
  <h2 class='headline'></h2>
  <p class='description'></p>
  <img src='https://placeimg.com/100/100'>
  <img src='https://placeimg.com/100/100'>
  <img src='https://placeimg.com/100/100'>
</div>


<script>
var cartCount = 0,
	buy = $(".btn"),
	span = $(".number"),
	cart = $(".cart"),
	quickview = $(".quickviewContainer"),
	quickViewBtn = $(".quickview"),
	close = $(".quickviewContainer .close"),
	minicart = [],
	totalPrice = [],
	miniCartPrice;

buy.on("click", addToCart);
quickViewBtn.on("click", quickView);
cart.on("click", showMiniCart);
close.on("click", function () {
	quickview.removeClass("active");
});

function quickView() {
	var description = $(this).parent().find(".description").text(),
		header = $(this).parent().find(".header").text(),
		price = $(this).find(".price"),
		quickViewHeader = $(".quickviewContainer .headline"),
		quickViewDescription = $(".quickviewContainer .description");
	clearTimeout(timeQuick);
	if (quickview.hasClass("active")) {
		quickview.removeClass("active");
		var timeQuick = setTimeout(function () {
			quickview.addClass("active");
		}, 300);
	} else {
		quickview.addClass("active");
	}

	quickViewHeader.text(header);
	quickViewDescription.text(description);
}

function showMiniCart() {
	$(".mini").toggleClass("visible");
}

function addToCart() {
	var self = $(this),
		productName = $(this).parent().find(".header").text(),
		miniCartNames = $(".products"),
		names = $(".names"),
		price = $(this).parent().find(".price").text(),
		priceInt = parseInt(price);

	totalPrice.push(priceInt);
	miniCartPrice = totalPrice.reduce(function (a, b) {
		return a + b;
	});
	$(".miniprice").text("Total amount: " + miniCartPrice + ",-");
	minicart.push(productName);
	lastProduct = minicart[minicart.length - 1];
	miniCartNames.text("Your cart lines: ");
	names.append("<p>" + lastProduct + "</p>");

	cartCount++;
	span.text(cartCount);
	clearTimeout(time);
	if (span.hasClass("update")) {
		span.removeClass("update");
		span.addClass("updateQuantity");
		var time = setTimeout(function () {
			span.removeClass("updateQuantity");
			span.addClass("update");
		}, 700);
	} else {
		span.addClass("update");
	}
	if (cartCount == 1) {
		cart.toggleClass("icon-basket icon-basket-loaded");
	}

	$(this).addClass("ok");
	var timeOk = setTimeout(function () {
		self.removeClass("ok");
	}, 1000);
}

</script>