(function () {
  const cond = window.matchMedia('(min-width: 992px) and (hover: hover) and (pointer: fine)');

  function enableDesktopVideos() {
    if (!cond.matches) return;

    document.querySelectorAll('video[autoplay][muted][playsinline] source[data-src]')
      .forEach(source => {
        const url = source.getAttribute('data-src');
        if (!url) return;
        source.setAttribute('src', url);
        source.removeAttribute('data-src');

        const video = source.closest('video');
        if (video) {
          video.load();
          const p = video.play && video.play();
          if (p && typeof p.then === 'function') p.catch(() => {});
        }
      });
  }

  document.addEventListener('DOMContentLoaded', enableDesktopVideos);

  if (cond.addEventListener) {
    cond.addEventListener('change', e => { if (e.matches) enableDesktopVideos(); });
  } else if (cond.addListener) {
    cond.addListener(e => { if (e.matches) enableDesktopVideos(); }); // старые браузеры
  }
})();