<!doctype html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<title><?php wp_title( '-', true, 'right' ); ?></title>
<link rel="profile" href="https://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url' ) ); ?>">
<?php // Loads HTML5 JavaScript file to add support for HTML5 elements in older IE versions. ?>
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>asset/js/html5.js?ver=3.7.0" type="text/javascript"></script>
<![endif]-->
<?php
$schema = get_post_meta(get_the_ID(), 'schema', true);
if(!empty($schema)) {
    echo $schema;
}
?>
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php wp_body_open(); ?>


<div id="page" class="hfeed site">

  <header id="header">


    
    <div class="main-header-bar-wrap">

      <div class="container flex main-menu-container">
        <div class="header-logo">
            
         <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
      
      <?php 
      
      $custom_logo_id = get_theme_mod( 'custom_logo' );
$logo = wp_get_attachment_image_src( $custom_logo_id , '' );
 
if ( has_custom_logo() ) {
    echo '<img src="' . esc_url( $logo[0] ) . '" alt="' . get_bloginfo( 'name' ) . '">';
} else {
    echo '<h1>' . get_bloginfo('name') . '</h1>';
}
      
      ?>
     </a> 

                  </div>


        <div class="mob__menu">
          <div class="mobile__button">
            <button id="trigger-overlay" type="button" class="open-menu-button">
              <img src="/wp-content/themes/hub/assets/img/burger.svg" alt="burger">
            </button>
          </div>
        </div>


   	<nav class="pc__menu">
		   
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'pc__menu',
					'menu_class'     => 'menu',
				)
			);
			?>

        
		
</nav>

        <div class="main-account-cont">
        
           
      <div class="main-header-search">
            
            <div class="search-button" id="header-search"><img src="/wp-content/themes/hub/assets/img/search.svg"></div>

          </div>

          <div class="main-header-profile">
            <a href="/my-account/"><img src="/wp-content/themes/hub/assets/img/profile.svg" alt="profile"></a>
          </div>

          <div class="main-header-cart">
                        <a class="menu-item cart-contents" href="/cart/" title="My Basket">
                            </a>
			  
			  
                  </div>
			
        </div>

      </div>

  <div class="container search-sec">
        <div class="search-container">
          <div  class="dgwt-wcas-search-wrapp dgwt-wcas-no-submit woocommerce dgwt-wcas-style-solaris js-dgwt-wcas-layout-classic dgwt-wcas-layout-classic js-dgwt-wcas-mobile-overlay-enabled">
		 <?php echo do_shortcode('[fibosearch]'); ?>
</div>
        </div>
      </div>

    </div>

    <div class="scroll-header show">
 <div class="main-header-bar-wrap">

      <div class="container flex main-menu-container">
        <div class="header-logo">
            
         <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
      
      <?php 
      
      $custom_logo_id = get_theme_mod( 'custom_logo' );
$logo = wp_get_attachment_image_src( $custom_logo_id , '' );
 
if ( has_custom_logo() ) {
    echo '<img src="' . esc_url( $logo[0] ) . '" alt="' . get_bloginfo( 'name' ) . '">';
} else {
    echo '<h1>' . get_bloginfo('name') . '</h1>';
}
      
      ?>
     </a> 

                  </div>


        <div class="mob__menu">
          <div class="mobile__button">
            <button id="trigger-overlay2" type="button" class="open-menu-button">
              <img src="/wp-content/themes/hub/assets/img/burger.svg" alt="burger">
            </button>
          </div>
        </div>


   	<nav class="pc__menu">
		    <nav class="main-menu">
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'pc__menu',
					'menu_class'     => 'menu',
				)
			);
			?>
        </nav>
</nav>

        <div class="main-account-cont">
          
      <div class="main-header-search">
            
         <div class="search-button" id="header-search"><img src="/wp-content/themes/hub/assets/img/search.svg"></div>

          </div>


          <div class="main-header-profile">
            <a href="/my-account/"><img src="/wp-content/themes/hub/assets/img/profile.svg" alt="profile"></a>
          </div>

          <div class="main-header-cart">
                        <a class="menu-item cart-contents" href="/cart/" title="My Basket">
                            </a>
                  </div>

        </div>

      </div>

  <div class="container search-sec">
        <div class="search-container">
          <div  class="dgwt-wcas-search-wrapp dgwt-wcas-no-submit woocommerce dgwt-wcas-style-solaris js-dgwt-wcas-layout-classic dgwt-wcas-layout-classic js-dgwt-wcas-mobile-overlay-enabled">
		 <?php echo do_shortcode('[fibosearch]'); ?>
</div>
        </div>
      </div>

    </div>
    </div>
	  
	  
	  
	  
	  
	  

    <div class="mob-show">
      <div class="overlay overlay-slidedown">

        <div class="container flex submenu-info">
          
          <div class="header-logo">
            
          </div>

          <button type="button" class="overlay-close"><span class="overlay-close-ico"></span></button>

        </div>
        
        <div class="container mob-menu-menulist">
          <nav class="mobile__menu">
              <nav class="main-menu">
			 <?php
			wp_nav_menu(
				array(
					'theme_location' => 'mobile__menu',
					'menu_class'     => 'menu',
				)
			);
			?>    
			  </nav>            </nav>
        </div>

    

      </div>
    </div>

  </header>