<?php


defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked yoast_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

?>


<div class="container breadcrumbscont">
<div class="page-information flex"><div class="breadcrumbs">
<?php
if ( function_exists('yoast_breadcrumb') ) {
  yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );
}
?>
</div>
<h1><?php woocommerce_page_title(); ?></h1>
</div></div>

<div class="container catalog flex">
	
<div class="filter-sidebar">
<div class="close-offset-menu"></div>
<div class="flex filter-mobile"><span class="filter-heading">FILTER</span> <span class="close-tabletab">
<img src="/wp-content/themes/hub/assets/img/close-filter.svg" alt="close">
</span>
</div>
<?php dynamic_sidebar('main_sidebar');?>
</div>
	
<div class="product-list">
<div class="woocommerce-notices-wrapper"></div>

<div class="loop-ordering-cont flex">
  <form class="woocommerce-ordering" method="get"> <select name="orderby" class="orderby order-hidden" data-attribute_name="attribute_weight" aria-label="Shop order">
      <option value="popularity">Popularity</option>
      <option value="rating">Average rating</option>
      <option value="date" selected="selected">Latest</option>
      <option value="price">Low to high</option>
      <option value="price-desc">High to low</option>
    </select>
    <p class="sorting-heading">Sorting:</p>
    <div class="catalog-inputorders">
      <div> <input class="category__filter" type="radio" name="orderby" id="Popularity" value="popularity"> <label for="Popularity">Popularity</label></div>
      <div> <input class="category__filter" type="radio" name="orderby" id="Average rating" value="rating"> <label for="Average rating">Average rating</label></div>
      <div> <input class="category__filter" type="radio" name="orderby" id="Latest" value="date" selected="selected"> <label for="Latest">Latest</label></div>
      <div> <input class="category__filter" type="radio" name="orderby" id="Low to high" value="price"> <label for="Low to high">Low to high</label></div>
      <div> <input class="category__filter" type="radio" name="orderby" id="High to low" value="price-desc"> <label for="High to low">High to low</label></div> <a href="?onsale=1" class="discount-btn">Discount</a>
    </div> <input type="hidden" name="paged" value="1"> <input type="hidden" name="onsale" value="1">
  </form> <button class="loop-filter-btn toc-menu"><img class=" ls-is-cached lazyloaded" src="/wp-content/themes/hub/assets/img/filter.svg" data-src="/wp-content/themes/hub/assets/img/filter.svg" alt="filter" width="24" height="24"></button>
</div>



<?php woocommerce_content(); ?>

</div>
</div>

	
<?php get_footer(); ?>