<?php


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<?php wc_print_notices(); ?>

<?php do_action( 'woocommerce_before_customer_login_form' ); ?>

<?php if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'yes' ) : ?>

<section class="woocommerce-auth">



<?php endif; ?>

<div class="tabs-buttons flex">
  <button class="tablink w3-red" onclick="opentabs(event,'customer_login')"><?php _e( 'Login', 'woocommerce' ); ?></button>
  <button class="tablink" onclick="opentabs(event,'customer_registration')"><?php _e( 'Register', 'woocommerce' ); ?></button>
</div>

<div class="home_tabs" id="customer_login" style="display: none;">
		<form class="woocommerce-form woocommerce-form-login login" method="post" style="display: none;">

			<?php do_action( 'woocommerce_login_form_start' ); ?>

			<p class="form-row form-row-first">
		
				<input type="text" class="input-text login-input" name="username" placeholder="Username or email address" id="username" value="<?php if ( ! empty( $_POST['username'] ) ) echo esc_attr( $_POST['username'] ); ?>" />
			</p>
			<p class="form-row form-row-last">
		
				<input class="input-text login-input" type="password" name="password" placeholder="Password" id="password" />
			</p>

			<?php do_action( 'woocommerce_login_form' ); ?>


	

<div class="form-row">
		
		<div class="login-lostandremember">
			<label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
				<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <?php _e( 'Remember me', 'woocommerce' ); ?> <span>Remember me</span>
			</label>

			<p class="lost_password">
				<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php _e( 'Lost your password?', 'woocommerce' ); ?></a>
			</p>

		</div>

		<input type="hidden" id="woocommerce-login-nonce" name="woocommerce-login-nonce" value="05753c81ac"><input type="hidden" name="_wp_http_referer" value="/checkout/">		<input type="hidden" name="redirect" value="<?php esc_attr_e( 'Login', 'woocommerce' ); ?>" />
		<button type="submit" class="woocommerce-button button woocommerce-form-login__submit" name="login" value="Login">Login</button>

	</div>

			<?php do_action( 'woocommerce_login_form_end' ); ?>

		</form>

<?php if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'yes' ) : ?>

	</div>
	
	


<div class="home_tabs" id="customer_registration" style="display: none;">


		<form method="post" class="register">

			<?php do_action( 'woocommerce_register_form_start' ); ?>

			<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

				<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
				
					<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" placeholder="Username" id="reg_username" value="<?php if ( ! empty( $_POST['username'] ) ) echo esc_attr( $_POST['username'] ); ?>" />
				</p>

			<?php endif; ?>

			<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
				
				<input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" placeholder="Email address" id="reg_email" value="<?php if ( ! empty( $_POST['email'] ) ) echo esc_attr( $_POST['email'] ); ?>" />
			</p>

			<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

				<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
					<label for="reg_password"><?php _e( 'Password', 'woocommerce' ); ?> <span class="required">*</span></label>
					<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" placeholder="Password" id="reg_password" />
				</p>

			<?php endif; ?>

			<!-- Spam Trap -->
			<div style="<?php echo ( ( is_rtl() ) ? 'right' : 'left' ); ?>: -999em; position: absolute;"><label for="trap"><?php _e( 'Anti-spam', 'woocommerce' ); ?></label><input type="text" name="email_2" id="trap" tabindex="-1" /></div>

			<?php do_action( 'woocommerce_register_form' ); ?>
			<?php do_action( 'register_form' ); ?>

			<p class="woocomerce-FormRow form-row">
				<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
				<input type="submit" class="woocommerce-Button woocommerce-button button woocommerce-form-register__submit" name="register" value="<?php esc_attr_e( 'Register', 'woocommerce' ); ?>" />
			</p>

			<?php do_action( 'woocommerce_register_form_end' ); ?>

		</form>

	</div>

</section>
<?php endif; ?>

<?php do_action( 'woocommerce_after_customer_login_form' ); ?>