<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

global $product;

if ( ! wc_review_ratings_enabled() ) {
    return;
}

$rating_count = $product->get_rating_count();
$review_count = $product->get_review_count();
$average      = $product->get_average_rating();

function custom_wc_get_rating_html( $rating, $count = 0 ) {
    $html = '';

    //if ( 0 < $rating ) {
        /* translators: %s: rating */
        $label = sprintf( __( 'Rated %s out of 5', 'woocommerce' ), $rating );
        $html  = '<div class="star-rating" role="img" aria-label="' . esc_attr( $label ) . '">' . wc_get_star_rating_html( $rating, $count ) . '</div>';
    //}

    return apply_filters( 'woocommerce_product_get_rating_html', $html, $rating, $count );
}
?>

    <div class="woocommerce-product-rating">
        <?php echo custom_wc_get_rating_html( $average, $rating_count ); // WPCS: XSS ok. ?>
        <?php if ( comments_open() ) : ?>
            <?php //phpcs:disable ?>
            <a href="#reviews" class="woocommerce-review-link" rel="nofollow">(<?php printf( _n( '%s customer review', '%s customer reviews', $review_count, 'woocommerce' ), '<span class="count">' . esc_html( $review_count ) . '</span>' ); ?>)</a>
            <?php // phpcs:enable ?>
        <?php endif ?>
    </div>