<?php
// Security check
if (!defined('ABSPATH')) exit;
?>
<div id="arix-importer-app" class="arix-importer-container">
    <!-- Sidebar Navigation -->
    <div class="arix-importer-sidebar">
        <div class="arix-importer-sidebar-header">
            <a href="#" class="arix-importer-logo">
                <div class="arix-importer-logo-icon">AP</div>
                <span>ARIX Pro Importer</span>
            </a>
        </div>
        
        <ul class="arix-importer-steps">
            <li class="arix-step-item active" data-step="upload">
                <a href="#" class="arix-step-link">
                    <span>1. Upload CSV</span>
                </a>
            </li>
            <li class="arix-step-item" data-step="mapping">
                <a href="#" class="arix-step-link">
                    <span>2. Column Mapping</span>
                </a>
            </li>
            <li class="arix-step-item" data-step="settings">
                <a href="#" class="arix-step-link">
                    <span>3. Import Settings</span>
                </a>
            </li>
            <li class="arix-step-item" data-step="importing">
                <a href="#" class="arix-step-link">
                    <span>4. Import Progress</span>
                </a>
            </li>
            <li class="arix-step-item" data-step="complete">
                <a href="#" class="arix-step-link">
                    <span>5. Complete</span>
                </a>
            </li>
        </ul>
        
        <div style="margin-top: auto; padding-top: 1.5rem; border-top: 1px solid var(--arix-border);">
            <div style="font-weight: 600; margin-bottom: 0.5rem; color: var(--arix-text);">Draft Enforcement</div>
            <p style="font-size: 0.875rem; color: var(--arix-text-secondary); margin: 0;">
                All products will be saved as drafts only. No products will be published during import.
            </p>
        </div>
    </div>
    
    <!-- Main Content Area -->
    <div class="arix-importer-content">
        <!-- Step 1: Upload CSV -->
        <div id="step_upload" class="arix-wizard-step active">
            <div class="arix-content-card">
                <h1 class="arix-page-title">Import Products from CSV</h1>
                <p class="arix-page-subtitle">Upload your CSV file to begin importing products into WooCommerce. All products will be saved as drafts only.</p>
                
                <div class="arix-dropzone" id="csv_dropzone">
                    <div class="arix-dropzone-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                            <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                            <polyline points="17 8 12 3 7 8"></polyline>
                            <line x1="12" y1="3" x2="12" y2="15"></line>
                        </svg>
                    </div>
                    <div class="arix-dropzone-text">Drag & Drop CSV File Here</div>
                    <div class="arix-dropzone-subtext">or click to browse your computer</div>
                    <button class="arix-btn arix-btn-large">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-right: 8px;">
                            <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                            <polyline points="17 8 12 3 7 8"></polyline>
                            <line x1="12" y1="3" x2="12" y2="15"></line>
                        </svg>
                        Select CSV File
                    </button>
                    <input type="file" id="csv_file_input" class="arix-file-input" accept=".csv,.txt">
                </div>
                
                <div id="csv_preview_container" style="margin-top: 2rem; display: none;">
                    <!-- CSV preview will be inserted here by JavaScript -->
                </div>
                
                <div style="display: flex; justify-content: flex-end; margin-top: 2rem;">
                    <button id="btn_next_upload" class="arix-btn arix-btn-large arix-btn-disabled" disabled>
                        Next: Column Mapping
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-left: 8px;">
                            <line x1="5" y1="12" x2="19" y2="12"></line>
                            <polyline points="12 5 19 12 12 19"></polyline>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Step 2: Column Mapping -->
        <div id="step_mapping" class="arix-wizard-step">
            <div class="arix-content-card">
                <h1 class="arix-page-title">Column Mapping</h1>
                <p class="arix-page-subtitle">Map your CSV columns to WooCommerce product fields. Drag and drop columns from the left panel to the right panel.</p>
                
                <div id="mapping_container">
                    <!-- Mapping UI will be rendered here by JavaScript -->
                    <div style="text-align: center; padding: 3rem; color: var(--arix-text-secondary);">
                        <div class="arix-loader" style="margin: 0 auto 1.5rem;"></div>
                        <p>Loading mapping interface...</p>
                    </div>
                </div>
                
                <div style="display: flex; justify-content: space-between; margin-top: 2rem;">
                    <button class="arix-btn arix-btn-secondary" onclick="ARIXImporter.currentStep='upload'; ARIXImporter.renderStep('upload');">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-right: 8px;">
                            <line x1="19" y1="12" x2="5" y2="12"></line>
                            <polyline points="12 19 5 12 12 5"></polyline>
                        </svg>
                        Previous: Upload CSV
                    </button>
                    <button id="btn_next_mapping" class="arix-btn arix-btn-large">
                        Next: Import Settings
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-left: 8px;">
                            <line x1="5" y1="12" x2="19" y2="12"></line>
                            <polyline points="12 5 19 12 12 19"></polyline>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Step 3: Import Settings -->
        <div id="step_settings" class="arix-wizard-step">
            <div class="arix-content-card">
                <h1 class="arix-page-title">Import Settings</h1>
                <p class="arix-page-subtitle">Configure advanced import settings before starting the import process.</p>
                
                <div id="import_settings_container">
                    <!-- Settings UI will be rendered here by JavaScript -->
                    <div style="text-align: center; padding: 3rem; color: var(--arix-text-secondary);">
                        <div class="arix-loader" style="margin: 0 auto 1.5rem;"></div>
                        <p>Loading settings...</p>
                    </div>
                </div>
                
                <div style="display: flex; justify-content: space-between; margin-top: 2rem;">
                    <button class="arix-btn arix-btn-secondary" onclick="ARIXImporter.currentStep='mapping'; ARIXImporter.renderStep('mapping');">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-right: 8px;">
                            <line x1="19" y1="12" x2="5" y2="12"></line>
                            <polyline points="12 19 5 12 12 5"></polyline>
                        </svg>
                        Previous: Column Mapping
                    </button>
                    <button id="btn_start_import" class="arix-btn arix-btn-large arix-btn-primary">
                        Start Import Process
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-left: 8px;">
                            <polygon points="5 3 19 12 5 21 5 3"></polygon>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Step 4: Importing -->
        <div id="step_importing" class="arix-wizard-step">
            <div class="arix-content-card">
                <h1 class="arix-page-title">Importing Products</h1>
                <p class="arix-page-subtitle">Your products are being imported as drafts. This process may take several minutes for large files.</p>
                
                <div class="arix-progress-container">
                    <div style="display: flex; justify-content: space-between; margin-bottom: 0.5rem;">
                        <span>Progress</span>
                        <span id="progress_percent">0%</span>
                    </div>
                    <div class="arix-progress-bar">
                        <div class="arix-progress-fill" id="progress_bar" style="width: 0%;"></div>
                    </div>
                    <div class="arix-progress-stats">
                        <span>Processed: <strong id="processed_count">0</strong> rows</span>
                        <span>Elapsed Time: <strong id="elapsed_time">0s</strong></span>
                    </div>
                </div>
                
                <div class="arix-summary-grid">
                    <div class="arix-summary-card success">
                        <div class="arix-summary-label">Successful</div>
                        <div class="arix-summary-number" id="success_count">0</div>
                        <div>Products Created</div>
                    </div>
                    <div class="arix-summary-card error">
                        <div class="arix-summary-label">Failed</div>
                        <div class="arix-summary-number" id="failed_count">0</div>
                        <div>Rows with Errors</div>
                    </div>
                    <div class="arix-summary-card warning">
                        <div class="arix-summary-label">Total Rows</div>
                        <div class="arix-summary-number" id="total_rows_count">0</div>
                        <div>Excluding Header</div>
                    </div>
                </div>
                
                <div id="import_errors" style="margin-top: 1.5rem;">
                    <!-- Errors will be displayed here -->
                </div>
                
                <div style="display: flex; justify-content: center; gap: 1rem; margin-top: 2rem;">
                    <button id="btn_resume_import" class="arix-btn arix-btn-secondary" style="display: none;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-right: 8px;">
                            <polygon points="5 3 19 12 5 21 5 3"></polygon>
                        </svg>
                        Resume Import
                    </button>
                    <button id="btn_cancel_import" class="arix-btn arix-btn-secondary" style="background: var(--arix-danger); color: white; border-color: var(--arix-danger);">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-right: 8px;">
                            <path d="M18 6L6 18"></path>
                            <path d="M6 6l12 12"></path>
                        </svg>
                        Cancel Import
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Step 5: Complete -->
        <div id="step_complete" class="arix-wizard-step">
            <div class="arix-content-card">
                <div style="text-align: center; padding: 3rem 2rem;">
                    <div style="width: 80px; height: 80px; background: rgba(16, 185, 129, 0.15); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1.5rem; border: 3px solid var(--arix-success);">
                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="var(--arix-success)" stroke-width="2">
                            <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path>
                            <polyline points="22 4 12 14.01 9 11.01"></polyline>
                        </svg>
                    </div>
                    <h1 class="arix-page-title" style="font-size: 2.25rem; margin-bottom: 1rem;">Import Complete!</h1>
                    <p class="arix-page-subtitle" style="font-size: 1.25rem; max-width: 600px; margin: 0 auto 2rem;">
                        All products have been successfully imported as drafts. No products were published.
                    </p>
                    
                    <div class="arix-summary-grid">
                        <div class="arix-summary-card">
                            <div class="arix-summary-label">Total Rows Processed</div>
                            <div class="arix-summary-number" id="total_rows_summary">0</div>
                        </div>
                        <div class="arix-summary-card success">
                            <div class="arix-summary-label">Products Created</div>
                            <div class="arix-summary-number" id="success_rows_summary">0</div>
                        </div>
                        <div class="arix-summary-card error">
                            <div class="arix-summary-label">Failed Rows</div>
                            <div class="arix-summary-number" id="failed_rows_summary">0</div>
                        </div>
                        <div class="arix-summary-card">
                            <div class="arix-summary-label">Elapsed Time</div>
                            <div class="arix-summary-number" id="elapsed_time_summary">0s</div>
                        </div>
                    </div>
                    
                    <div style="background: var(--arix-sidebar-bg); border-radius: 12px; padding: 1.5rem; margin: 2rem auto; max-width: 600px;">
                        <h3 style="margin-top: 0; display: flex; align-items: center;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-right: 8px; color: var(--arix-warning);">
                                <circle cx="12" cy="12" r="10"></circle>
                                <line x1="12" y1="8" x2="12" y2="12"></line>
                                <line x1="12" y1="16" x2="12.01" y2="16"></line>
                            </svg>
                            Important Next Steps
                        </h3>
                        <ul style="padding-left: 1.5rem; margin: 0.75rem 0; color: var(--arix-text-secondary);">
                            <li style="margin-bottom: 0.5rem;">Review draft products in <strong>WooCommerce > Products</strong></li>
                            <li style="margin-bottom: 0.5rem;">Edit any products that need adjustments</li>
                            <li>Manually publish products when ready</li>
                        </ul>
                    </div>
                    
                    <div style="display: flex; justify-content: center; gap: 1rem; margin-top: 2rem; flex-wrap: wrap;">
                        <a href="<?php echo admin_url('edit.php?post_type=product&post_status=draft'); ?>" class="arix-btn arix-btn-large" style="background: var(--arix-primary); padding: 1rem 2.5rem;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-right: 8px;">
                                <path d="M4 19.5A2.5 2.5 0 0 1 6.5 17H20"></path>
                                <path d="M6.5 2H20v20H6.5A2.5 2.5 0 0 1 4 19.5v-15A2.5 2.5 0 0 1 6.5 2z"></path>
                            </svg>
                            View Draft Products
                        </a>
                        <button onclick="location.reload();" class="arix-btn arix-btn-secondary arix-btn-large" style="padding: 1rem 2.5rem;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-right: 8px;">
                                <path d="M21.5 2v6h-6M2.5 22v-6h6M2 11.5a10 10 0 0 1 18.8-4.3M22 12.5a10 10 0 0 1-18.8 4.3"></path>
                            </svg>
                            Start New Import
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Inline critical CSS for initial render */
#arix-importer-app { opacity: 0; transition: opacity 0.3s ease; }
#arix-importer-app.arix-loaded { opacity: 1; }
</style>

<script>
// Initialize loading state
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('arix-importer-app').classList.add('arix-loaded');
});
</script>