/**
 * Customizer controls toggles
 *
 * @package Phast
 */

( function( $ ) {

	/* Internal shorthand */
	var api = wp.customize;

	/**
	 * Trigger hooks
	 */
	ASTControlTrigger = {

	    /**
	     * Trigger a hook.
	     *
	     * @since 1.0.0
	     * @method triggerHook
	     * @param {String} hook The hook to trigger.
	     * @param {Array} args An array of args to pass to the hook.
		 */
	    triggerHook: function( hook, args )
	    {
	    	$( 'body' ).trigger( 'phast-control-trigger.' + hook, args );
	    },

	    /**
	     * Add a hook.
	     *
	     * @since 1.0.0
	     * @method addHook
	     * @param {String} hook The hook to add.
	     * @param {Function} callback A function to call when the hook is triggered.
	     */
	    addHook: function( hook, callback )
	    {
	    	$( 'body' ).on( 'phast-control-trigger.' + hook, callback );
	    },

	    /**
	     * Remove a hook.
	     *
	     * @since 1.0.0
	     * @method removeHook
	     * @param {String} hook The hook to remove.
	     * @param {Function} callback The callback function to remove.
	     */
	    removeHook: function( hook, callback )
	    {
		    $( 'body' ).off( 'phast-control-trigger.' + hook, callback );
	    },
	};

	/**
	 * Helper class that contains data for showing and hiding controls.
	 *
	 * @since 1.0.0
	 * @class ASTCustomizerToggles
	 */
	ASTCustomizerToggles = {

		'phast-settings[display-site-title]' : [],

		'phast-settings[display-site-tagline]' : [],

		'phast-settings[ast-header-retina-logo]' :[],

		'custom_logo' : [],
		
		/**
		 * Section - Header
		 *
		 * @link  ?autofocus[section]=section-header
		 */

		/**
		 * Layout 2
		 */
		// Layout 2 > Right Section > Text / HTML
		// Layout 2 > Right Section > Search Type
		// Layout 2 > Right Section > Search Type > Search Box Type.
		'phast-settings[header-main-rt-section]' : [],
		

		'phast-settings[hide-custom-menu-mobile]' :[],
		

		/**
		 * Blog
		 */
		'phast-settings[blog-width]' :[],
		
		'phast-settings[blog-post-structure]' :[],

		/**
		 * Blog Single
		 */
		 'phast-settings[blog-single-post-structure]' : [],
		
		'phast-settings[blog-single-width]' : [],
		
		'phast-settings[blog-single-meta]' :[], 
		

		/**
		 * Small Footer
		 */
		'phast-settings[footer-sml-layout]' : [],
		
		'phast-settings[footer-sml-section-1]' :[],
		
		'phast-settings[footer-sml-section-2]' :[],
		
		'phast-settings[footer-sml-divider]' :[],
		
		'phast-settings[header-main-sep]' :[],
	
		'phast-settings[disable-primary-nav]' :[],
		
		/**
		 * Footer Widgets
		 */
		'phast-settings[footer-adv]' :[],
		
		'phast-settings[shop-archive-width]' :[],
		
		'phast-settings[mobile-header-logo]' :[],
		
		'phast-settings[different-mobile-logo]' :[],

	};

} )( jQuery );