<?php
/**
 * Phast functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Phast
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Define Constants
 */
define( 'PHAST_THEME_VERSION', '2.5.4' );
define( 'PHAST_THEME_SETTINGS', 'phast-settings' );
define( 'PHAST_THEME_DIR', trailingslashit( get_template_directory() ) );
define( 'PHAST_THEME_URI', trailingslashit( esc_url( get_template_directory_uri() ) ) );


/**
 * Minimum Version requirement of the Phast Pro addon.
 * This constant will be used to display the notice asking user to update the Phast addon to latest version.
 */
define( 'PHAST_EXT_MIN_VER', '2.6.0' );

/**
 * Setup helper functions of Phast.
 */
require_once PHAST_THEME_DIR . 'inc/core/class-phast-theme-options.php';
require_once PHAST_THEME_DIR . 'inc/core/class-theme-strings.php';
require_once PHAST_THEME_DIR . 'inc/core/common-functions.php';

/**
 * Update theme
 */
require_once PHAST_THEME_DIR . 'inc/theme-update/class-phast-theme-update.php';
require_once PHAST_THEME_DIR . 'inc/theme-update/phast-update-functions.php';
require_once PHAST_THEME_DIR . 'inc/theme-update/class-phast-theme-background-updater.php';
require_once PHAST_THEME_DIR . 'inc/theme-update/class-phast-pb-compatibility.php';


/**
 * Fonts Files
 */
require_once PHAST_THEME_DIR . 'inc/customizer/class-phast-font-families.php';
if ( is_admin() ) {
	require_once PHAST_THEME_DIR . 'inc/customizer/class-phast-fonts-data.php';
}

require_once PHAST_THEME_DIR . 'inc/customizer/class-phast-fonts.php';

require_once PHAST_THEME_DIR . 'inc/core/class-phast-walker-page.php';
require_once PHAST_THEME_DIR . 'inc/core/class-phast-enqueue-scripts.php';
require_once PHAST_THEME_DIR . 'inc/core/class-gutenberg-editor-css.php';
require_once PHAST_THEME_DIR . 'inc/class-phast-dynamic-css.php';

/**
 * Custom template tags for this theme.
 */
require_once PHAST_THEME_DIR . 'inc/core/class-phast-attr.php';
require_once PHAST_THEME_DIR . 'inc/template-tags.php';

require_once PHAST_THEME_DIR . 'inc/widgets.php';
require_once PHAST_THEME_DIR . 'inc/core/theme-hooks.php';
require_once PHAST_THEME_DIR . 'inc/admin-functions.php';
require_once PHAST_THEME_DIR . 'inc/core/sidebar-manager.php';

/**
 * Markup Functions
 */
require_once PHAST_THEME_DIR . 'inc/markup-extras.php';
require_once PHAST_THEME_DIR . 'inc/extras.php';
require_once PHAST_THEME_DIR . 'inc/blog/blog-config.php';
require_once PHAST_THEME_DIR . 'inc/blog/blog.php';
require_once PHAST_THEME_DIR . 'inc/blog/single-blog.php';
/**
 * Markup Files
 */
require_once PHAST_THEME_DIR . 'inc/template-parts.php';
require_once PHAST_THEME_DIR . 'inc/class-phast-loop.php';
require_once PHAST_THEME_DIR . 'inc/class-phast-mobile-header.php';

/**
 * Functions and definitions.
 */
require_once PHAST_THEME_DIR . 'inc/class-phast-after-setup-theme.php';

// Required files.
require_once PHAST_THEME_DIR . 'inc/core/class-phast-admin-helper.php';

require_once PHAST_THEME_DIR . 'inc/schema/class-phast-schema.php';

if ( is_admin() ) {

	/**
	 * Admin Menu Settings
	 */
	require_once PHAST_THEME_DIR . 'inc/core/class-phast-admin-settings.php';
	require_once PHAST_THEME_DIR . 'inc/lib/notices/class-phast-notices.php';

	/**
	 * Metabox additions.
	 */
	require_once PHAST_THEME_DIR . 'inc/metabox/class-phast-meta-boxes.php';
}

require_once PHAST_THEME_DIR . 'inc/metabox/class-phast-meta-box-operations.php';


/**
 * Customizer additions.
 */
require_once PHAST_THEME_DIR . 'inc/customizer/class-phast-customizer.php';


/**
 * Compatibility
 */
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-jetpack.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/woocommerce/class-phast-woocommerce.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/edd/class-phast-edd.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/lifterlms/class-phast-lifterlms.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/learndash/class-phast-learndash.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-beaver-builder.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-bb-ultimate-addon.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-contact-form-7.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-visual-composer.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-site-origin.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-gravity-forms.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-bne-flyout.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-ubermeu.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-divi-builder.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-amp.php';
require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-yoast-seo.php';
require_once PHAST_THEME_DIR . 'inc/addons/transparent-header/class-phast-ext-transparent-header.php';
require_once PHAST_THEME_DIR . 'inc/addons/breadcrumbs/class-phast-breadcrumbs.php';
require_once PHAST_THEME_DIR . 'inc/addons/heading-colors/class-phast-heading-colors.php';
require_once PHAST_THEME_DIR . 'inc/class-phast-filesystem.php';

// Elementor Compatibility requires PHP 5.4 for namespaces.
if ( version_compare( PHP_VERSION, '5.4', '>=' ) ) {
	require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-elementor.php';
	require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-elementor-pro.php';
}

// Beaver Themer compatibility requires PHP 5.3 for anonymus functions.
if ( version_compare( PHP_VERSION, '5.3', '>=' ) ) {
	require_once PHAST_THEME_DIR . 'inc/compatibility/class-phast-beaver-themer.php';
}

/**
 * Load deprecated functions
 */
require_once PHAST_THEME_DIR . 'inc/core/deprecated/deprecated-filters.php';
require_once PHAST_THEME_DIR . 'inc/core/deprecated/deprecated-hooks.php';
require_once PHAST_THEME_DIR . 'inc/core/deprecated/deprecated-functions.php';
