<?php
/**
 * The header for Phast Theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Phast
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?><!DOCTYPE html>
<?php phast_html_before(); ?>
<html <?php language_attributes(); ?>>
<head>
<?php phast_head_top(); ?>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="https://gmpg.org/xfn/11">

<?php wp_head(); ?>
<?php phast_head_bottom(); ?>
</head>

<body <?php phast_schema_body(); ?> <?php body_class(); ?>>

<?php phast_body_top(); ?>
<?php wp_body_open(); ?>
<div 
	<?php
	echo phast_attr(
		'site',
		array(
			'id'    => 'page',
			'class' => 'hfeed site',
		)
	);
	?>
>
	<a class="skip-link screen-reader-text" href="#content"><?php echo esc_html( phast_default_strings( 'string-header-skip-link', false ) ); ?></a>

	<?php phast_header_before(); ?>

	<?php phast_header(); ?>

	<?php phast_header_after(); ?>

	<?php phast_content_before(); ?>

	<div id="content" class="site-content">

		<div class="ast-container">

		<?php phast_content_top(); ?>
