<?php
/**
 * Colors - Breadcrumbs Options for theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.7.0
 */

// Block direct access to the file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Bail if Customizer config base class does not exist.
if ( ! class_exists( 'Phast_Customizer_Config_Base' ) ) {
	return;
}

/**
 * Customizer Sanitizes
 *
 * @since 1.7.0
 */
if ( ! class_exists( 'Phast_Breadcrumbs_Color_Configs' ) ) {

	/**
	 * Register Colors and Background - Breadcrumbs Options Customizer Configurations.
	 */
	class Phast_Breadcrumbs_Color_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Colors and Background - Breadcrumbs Options Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.7.0
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$defaults = Phast_Theme_Options::defaults();

			$_configs = array(

				/**
				 * Option: Divider
				 * Option: breadcrumb color Section divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[section-breadcrumb-color-divider]',
					'type'     => 'control',
					'control'  => 'ast-heading',
					'section'  => 'section-breadcrumb',
					'title'    => __( 'Colors', 'phast' ),
					'required' => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'priority' => 72,
					'settings' => array(),
				),

				/*
				 * Breadcrumb Color
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[section-breadcrumb-color]',
					'default'   => phast_get_option( 'section-breadcrumb-color' ),
					'type'      => 'control',
					'required'  => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'control'   => 'ast-settings-group',
					'title'     => __( 'Content', 'phast' ),
					'section'   => 'section-breadcrumb',
					'transport' => 'postMessage',
					'priority'  => 72,
				),

				array(
					'name'       => 'breadcrumb-bg-color',
					'type'       => 'sub-control',
					'default'    => phast_get_option( 'breadcrumb-bg-color' ),
					'parent'     => PHAST_THEME_SETTINGS . '[section-breadcrumb-color]',
					'section'    => 'section-breadcrumb',
					'transport'  => 'postMessage',
					'tab'        => __( 'Normal', 'phast' ),
					'control'    => 'ast-responsive-color',
					'title'      => __( 'Background Color', 'phast' ),
					'responsive' => true,
					'rgba'       => true,
					'priority'   => 5,
				),

				array(
					'name'       => 'breadcrumb-active-color-responsive',
					'default'    => phast_get_option( 'breadcrumb-active-color-responsive' ),
					'type'       => 'sub-control',
					'parent'     => PHAST_THEME_SETTINGS . '[section-breadcrumb-color]',
					'section'    => 'section-breadcrumb',
					'transport'  => 'postMessage',
					'tab'        => __( 'Normal', 'phast' ),
					'control'    => 'ast-responsive-color',
					'title'      => __( 'Text Color', 'phast' ),
					'responsive' => true,
					'rgba'       => true,
					'priority'   => 10,
				),

				array(
					'name'       => 'breadcrumb-text-color-responsive',
					'default'    => phast_get_option( 'breadcrumb-text-color-responsive' ),
					'type'       => 'sub-control',
					'parent'     => PHAST_THEME_SETTINGS . '[section-breadcrumb-color]',
					'section'    => 'section-breadcrumb',
					'transport'  => 'postMessage',
					'tab'        => __( 'Normal', 'phast' ),
					'control'    => 'ast-responsive-color',
					'title'      => __( 'Link Color', 'phast' ),
					'responsive' => true,
					'rgba'       => true,
					'priority'   => 15,
				),

				array(
					'name'       => 'breadcrumb-hover-color-responsive',
					'default'    => phast_get_option( 'breadcrumb-hover-color-responsive' ),
					'type'       => 'sub-control',
					'parent'     => PHAST_THEME_SETTINGS . '[section-breadcrumb-color]',
					'section'    => 'section-breadcrumb',
					'transport'  => 'postMessage',
					'tab'        => __( 'Hover', 'phast' ),
					'control'    => 'ast-responsive-color',
					'title'      => __( 'Link Color', 'phast' ),
					'responsive' => true,
					'rgba'       => true,
					'priority'   => 20,
				),

				array(
					'name'       => 'breadcrumb-separator-color',
					'default'    => phast_get_option( 'breadcrumb-separator-color' ),
					'type'       => 'sub-control',
					'parent'     => PHAST_THEME_SETTINGS . '[section-breadcrumb-color]',
					'section'    => 'section-breadcrumb',
					'transport'  => 'postMessage',
					'tab'        => __( 'Normal', 'phast' ),
					'control'    => 'ast-responsive-color',
					'title'      => __( 'Separator Color', 'phast' ),
					'responsive' => true,
					'rgba'       => true,
					'priority'   => 25,
				),
			);

			return array_merge( $configurations, $_configs );
		}
	}
}

/**
 * Kicking this off by calling 'get_instance()' method
 */
new Phast_Breadcrumbs_Color_Configs();
