<?php
/**
 * Breadcrumbs Options for Phast theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.7.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Breadcrumbs_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Breadcrumbs_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Phast-Breadcrumbs Settings.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.7.0
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$breadcrumb_source_list = apply_filters(
				'phast_breadcrumb_source_list',
				array(
					'default' => __( 'Default', 'phast' ),
				),
				'breadcrumb-list'
			);

			$_configs = array(

				/*
				 * Breadcrumb
				 */
				array(
					'name'               => 'section-breadcrumb',
					'type'               => 'section',
					'priority'           => 20,
					'title'              => __( 'Breadcrumb', 'phast' ),
					'description_hidden' => true,
					'description'        => $this->section_get_description(
						array(
							'description' => '<p><b>' . __( 'Helpful Information', 'phast' ) . '</b></p>',
							'links'       => array(
								array(
									'text'  => __( 'Breadcrumb Overview', 'phast' ) . ' &#187;',
									'attrs' => array(
										'href' => phast_get_pro_url( 'https://wpphast.com/docs/add-breadcrumbs-with-phast/', 'customizer', 'sidebar', 'helpful-information' ),
									),
								),
							),
						)
					),
				),

				/**
				 * Option: Breadcrumb Position
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[breadcrumb-position]',
					'default'  => 'none',
					'section'  => 'section-breadcrumb',
					'title'    => __( 'Position', 'phast' ),
					'type'     => 'control',
					'control'  => 'select',
					'priority' => 5,
					'choices'  => array(
						'none'                      => __( 'None', 'phast' ),
						'phast_masthead_content'    => __( 'Inside Header', 'phast' ),
						'phast_header_markup_after' => __( 'After Header', 'phast' ),
						'phast_entry_top'           => __( 'Before Title', 'phast' ),
					),
					'partial'  => array(
						'selector'            => '.ast-breadcrumbs-wrapper .ast-breadcrumbs .trail-items',
						'container_inclusive' => false,
					),
				),

				/**
				 * Option: Breadcrumb Source
				 */
				array(
					'name'            => PHAST_THEME_SETTINGS . '[select-breadcrumb-source]',
					'default'         => 'default',
					'section'         => 'section-breadcrumb',
					'required'        => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'title'           => __( 'Breadcrumb Source', 'phast' ),
					'type'            => 'control',
					'control'         => 'select',
					'priority'        => 10,
					'choices'         => $breadcrumb_source_list,
					'active_callback' => array( $this, 'is_third_party_breadcrumb_active' ),
				),

				/**
				 * Option: Breadcrumb Separator
				 */
				array(
					'name'            => PHAST_THEME_SETTINGS . '[breadcrumb-separator]',
					'type'            => 'control',
					'control'         => 'text',
					'section'         => 'section-breadcrumb',
					'default'         => phast_get_option( 'breadcrumb-separator' ) ? phast_get_option( 'breadcrumb-separator' ) : '\00bb',
					'required'        => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'priority'        => 15,
					'title'           => __( 'Separator', 'phast' ),
					'active_callback' => array( $this, 'is_selected_breadcrumb_active' ),
				),

				/**
				 * Option: Disable Breadcrumb on Categories
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[breadcrumb-disable-home-page]',
					'default'  => phast_get_option( 'breadcrumb-disable-home-page' ),
					'type'     => 'control',
					'section'  => 'section-breadcrumb',
					'required' => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'title'    => __( 'Disable on Home Page?', 'phast' ),
					'priority' => 25,
					'control'  => 'checkbox',
				),

				/**
				 * Option: Disable Breadcrumb on Categories
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[breadcrumb-disable-blog-posts-page]',
					'default'     => phast_get_option( 'breadcrumb-disable-blog-posts-page' ),
					'type'        => 'control',
					'section'     => 'section-breadcrumb',
					'description' => __( 'Latest posts page or when any page is selected as blog page', 'phast' ),
					'required'    => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'title'       => __( 'Disable on Blog / Posts Page?', 'phast' ),
					'priority'    => 25,
					'control'     => 'checkbox',
				),

				/**
				 * Option: Disable Breadcrumb on Search
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[breadcrumb-disable-search]',
					'default'  => phast_get_option( 'breadcrumb-disable-search' ),
					'type'     => 'control',
					'section'  => 'section-breadcrumb',
					'required' => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'title'    => __( 'Disable on Search?', 'phast' ),
					'priority' => 30,
					'control'  => 'checkbox',
				),

				/**
				 * Option: Disable Breadcrumb on Archive
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[breadcrumb-disable-archive]',
					'default'  => phast_get_option( 'breadcrumb-disable-archive' ),
					'type'     => 'control',
					'section'  => 'section-breadcrumb',
					'required' => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'title'    => __( 'Disable on Archive?', 'phast' ),
					'priority' => 35,
					'control'  => 'checkbox',
				),

				/**
				 * Option: Disable Breadcrumb on Single Page
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[breadcrumb-disable-single-page]',
					'default'  => phast_get_option( 'breadcrumb-disable-single-page' ),
					'type'     => 'control',
					'section'  => 'section-breadcrumb',
					'required' => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'title'    => __( 'Disable on Single Page?', 'phast' ),
					'priority' => 40,
					'control'  => 'checkbox',
				),

				/**
				 * Option: Disable Breadcrumb on Single Post
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[breadcrumb-disable-single-post]',
					'default'  => phast_get_option( 'breadcrumb-disable-single-post' ),
					'type'     => 'control',
					'section'  => 'section-breadcrumb',
					'required' => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'title'    => __( 'Disable on Single Post?', 'phast' ),
					'priority' => 45,
					'control'  => 'checkbox',
				),

				/**
				 * Option: Disable Breadcrumb on Singular
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[breadcrumb-disable-singular]',
					'default'     => phast_get_option( 'breadcrumb-disable-singular' ),
					'type'        => 'control',
					'section'     => 'section-breadcrumb',
					'description' => __( 'All Pages, All Posts, All Attachments', 'phast' ),
					'required'    => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'title'       => __( 'Disable on Singular?', 'phast' ),
					'priority'    => 50,
					'control'     => 'checkbox',
				),

				/**
				 * Option: Disable Breadcrumb on 404 Page
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[breadcrumb-disable-404-page]',
					'default'  => phast_get_option( 'breadcrumb-disable-404-page' ),
					'type'     => 'control',
					'section'  => 'section-breadcrumb',
					'required' => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'title'    => __( 'Disable on 404 Page?', 'phast' ),
					'priority' => 55,
					'control'  => 'checkbox',
				),

				/**
				 * Option: Breadcrumb Alignment
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[breadcrumb-alignment]',
					'default'   => 'left',
					'section'   => 'section-breadcrumb',
					'transport' => 'postMessage',
					'required'  => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'title'     => __( 'Alignment', 'phast' ),
					'type'      => 'control',
					'control'   => 'select',
					'priority'  => 65,
					'choices'   => array(
						'left'   => __( 'Left', 'phast' ),
						'center' => __( 'Center', 'phast' ),
						'right'  => __( 'Right', 'phast' ),
					),
				),

				/**
				 * Option: Breadcrumb Spacing
				 */
				array(
					'name'           => PHAST_THEME_SETTINGS . '[breadcrumb-spacing]',
					'default'        => phast_get_option( 'breadcrumb-spacing' ),
					'type'           => 'control',
					'transport'      => 'postMessage',
					'control'        => 'ast-responsive-spacing',
					'priority'       => 70,
					'title'          => __( 'Spacing', 'phast' ),
					'linked_choices' => true,
					'unit_choices'   => array( 'px', 'em', '%' ),
					'choices'        => array(
						'top'    => __( 'Top', 'phast' ),
						'right'  => __( 'Right', 'phast' ),
						'bottom' => __( 'Bottom', 'phast' ),
						'left'   => __( 'Left', 'phast' ),
					),
					'required'       => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'section'        => 'section-breadcrumb',
				),
			);

			return array_merge( $configurations, $_configs );

		}

		/**
		 * Is third-party breadcrumb active.
		 * Decide if the Source option should be visible depending on third party plugins.
		 *
		 * @return boolean  True - If the option should be displayed, False - If the option should be hidden.
		 */
		public function is_third_party_breadcrumb_active() {

			// Check if breadcrumb is turned on from WPSEO option.
			$breadcrumb_enable = is_callable( 'WPSEO_Options::get' ) ? WPSEO_Options::get( 'breadcrumbs-enable' ) : false;
			$wpseo_option      = get_option( 'wpseo_internallinks' ) ? get_option( 'wpseo_internallinks' ) : $breadcrumb_enable;
			if ( ! is_array( $wpseo_option ) ) {
				unset( $wpseo_option );
				$wpseo_option = array(
					'breadcrumbs-enable' => $breadcrumb_enable,
				);
			}

			if ( function_exists( 'yoast_breadcrumb' ) && true === $wpseo_option['breadcrumbs-enable'] ) {
				// Check if breadcrumb is turned on from SEO Yoast plugin.
				return true;
			} elseif ( function_exists( 'bcn_display' ) ) {
				// Check if breadcrumb is turned on from Breadcrumb NavXT plugin.
				return true;
			} elseif ( function_exists( 'rank_math_the_breadcrumbs' ) ) {
				// Check if breadcrumb is turned on from Rank Math plugin.
				return true;
			} else {
				return false;
			}
		}

		/**
		 * Is selected third-party breadcrumb active.
		 * Decide if the Separator option should be visible depending on third party plugins.
		 *
		 * @return boolean  True - If the option should be displayed, False - If the option should be hidden.
		 */
		public function is_selected_breadcrumb_active() {

			// Check if breadcrumb is turned on from WPSEO option.
			$selected_breadcrumb_source = phast_get_option( 'select-breadcrumb-source' );
			$breadcrumb_enable          = is_callable( 'WPSEO_Options::get' ) ? WPSEO_Options::get( 'breadcrumbs-enable' ) : false;
			$wpseo_option               = get_option( 'wpseo_internallinks' ) ? get_option( 'wpseo_internallinks' ) : $breadcrumb_enable;
			if ( ! is_array( $wpseo_option ) ) {

				unset( $wpseo_option );
				$wpseo_option = array(
					'breadcrumbs-enable' => $breadcrumb_enable,
				);
			}

			if ( function_exists( 'yoast_breadcrumb' ) && true === $wpseo_option['breadcrumbs-enable'] && 'yoast-seo-breadcrumbs' === $selected_breadcrumb_source ) {
				// Check if breadcrumb is turned on from SEO Yoast plugin.
				return false;
			} elseif ( function_exists( 'bcn_display' ) && 'breadcrumb-navxt' === $selected_breadcrumb_source ) {
				// Check if breadcrumb is turned on from Breadcrumb NavXT plugin.
				return false;
			} elseif ( function_exists( 'rank_math_the_breadcrumbs' ) && 'rank-math' === $selected_breadcrumb_source ) {
				// Check if breadcrumb is turned on from Rank Math plugin.
				return false;
			} else {
				return true;
			}
		}
	}
}

new Phast_Breadcrumbs_Configs();
