<?php
/**
 * Typography - Breadcrumbs Options for theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.7.0
 */

// Block direct access to the file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Bail if Customizer config base class does not exist.
if ( ! class_exists( 'Phast_Customizer_Config_Base' ) ) {
	return;
}

/**
 * Customizer Sanitizes
 *
 * @since 1.7.0
 */
if ( ! class_exists( 'Phast_Breadcrumbs_Typo_Configs' ) ) {

	/**
	 * Register Colors and Background - Breadcrumbs Options Customizer Configurations.
	 */
	class Phast_Breadcrumbs_Typo_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Colors and Background - Breadcrumbs Options Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.7.0
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$defaults = Phast_Theme_Options::defaults();

			$_configs = array(

				/**
				 * Option: Divider
				 * Option: breadcrumb Typography Section divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[section-breadcrumb-typography-divider]',
					'type'     => 'control',
					'control'  => 'ast-heading',
					'section'  => 'section-breadcrumb',
					'title'    => __( 'Typography', 'phast' ),
					'required' => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'priority' => 73,
					'settings' => array(),
				),

				/*
				 * Breadcrumb Typography
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[section-breadcrumb-typo]',
					'default'   => phast_get_option( 'section-breadcrumb-typo' ),
					'type'      => 'control',
					'required'  => array( PHAST_THEME_SETTINGS . '[breadcrumb-position]', '!=', 'none' ),
					'control'   => 'ast-settings-group',
					'title'     => __( 'Content', 'phast' ),
					'section'   => 'section-breadcrumb',
					'transport' => 'postMessage',
					'priority'  => 73,
				),

				/**
				 * Option: Font Family
				 */
				array(
					'name'      => 'breadcrumb-font-family',
					'default'   => phast_get_option( 'breadcrumb-font-family' ),
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[section-breadcrumb-typo]',
					'section'   => 'section-breadcrumb',
					'control'   => 'ast-font',
					'font_type' => 'ast-font-family',
					'title'     => __( 'Family', 'phast' ),
					'connect'   => 'breadcrumb-font-weight',
					'priority'  => 5,
				),

				/**
				 * Option: Font Size
				 */
				array(
					'name'        => 'breadcrumb-font-size',
					'control'     => 'ast-responsive',
					'type'        => 'sub-control',
					'parent'      => PHAST_THEME_SETTINGS . '[section-breadcrumb-typo]',
					'section'     => 'section-breadcrumb',
					'default'     => phast_get_option( 'breadcrumb-font-size' ),
					'transport'   => 'postMessage',
					'title'       => __( 'Size', 'phast' ),
					'priority'    => 10,
					'input_attrs' => array(
						'min' => 0,
					),
					'units'       => array(
						'px' => 'px',
						'em' => 'em',
					),
				),

				/**
				 * Option: Font Weight
				 */
				array(
					'name'              => 'breadcrumb-font-weight',
					'control'           => 'ast-font',
					'type'              => 'sub-control',
					'parent'            => PHAST_THEME_SETTINGS . '[section-breadcrumb-typo]',
					'section'           => 'section-breadcrumb',
					'font_type'         => 'ast-font-weight',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_font_weight' ),
					'default'           => phast_get_option( 'breadcrumb-font-weight' ),
					'title'             => __( 'Weight', 'phast' ),
					'connect'           => 'breadcrumb-font-family',
					'priority'          => 15,
				),

				/**
				 * Option: Text Transform
				 */
				array(
					'name'      => 'breadcrumb-text-transform',
					'control'   => 'ast-select',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[section-breadcrumb-typo]',
					'section'   => 'section-breadcrumb',
					'default'   => phast_get_option( 'breadcrumb-text-transform' ),
					'title'     => __( 'Text Transform', 'phast' ),
					'transport' => 'postMessage',
					'priority'  => 20,
					'choices'   => array(
						''           => __( 'Inherit', 'phast' ),
						'none'       => __( 'None', 'phast' ),
						'capitalize' => __( 'Capitalize', 'phast' ),
						'uppercase'  => __( 'Uppercase', 'phast' ),
						'lowercase'  => __( 'Lowercase', 'phast' ),
					),
				),

				/**
				 * Option: Line Height
				 */
				array(
					'name'              => 'breadcrumb-line-height',
					'control'           => 'ast-slider',
					'transport'         => 'postMessage',
					'type'              => 'sub-control',
					'default'           => '',
					'parent'            => PHAST_THEME_SETTINGS . '[section-breadcrumb-typo]',
					'section'           => 'section-breadcrumb',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_number_n_blank' ),
					'title'             => __( 'Line Height', 'phast' ),
					'suffix'            => '',
					'priority'          => 25,
					'input_attrs'       => array(
						'min'  => 1,
						'step' => 0.01,
						'max'  => 5,
					),
				),

			);

			return array_merge( $configurations, $_configs );
		}
	}
}

/**
 * Kicking this off by calling 'get_instance()' method
 */
new Phast_Breadcrumbs_Typo_Configs();
