<?php
/**
 * Heading Colors for Phast theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 2.1.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'PHAST_THEME_HEADING_COLORS_DIR', PHAST_THEME_DIR . 'inc/addons/heading-colors/' );
define( 'PHAST_THEME_HEADING_COLORS_URI', PHAST_THEME_URI . 'inc/addons/heading-colors/' );

if ( ! class_exists( 'Phast_Heading_Colors' ) ) {

	/**
	 * Heading Initial Setup
	 *
	 * @since 2.1.4
	 */
	class Phast_Heading_Colors {

		/**
		 * Constructor function that initializes required actions and hooks
		 */
		public function __construct() {

			require_once PHAST_THEME_HEADING_COLORS_DIR . 'class-phast-heading-colors-loader.php';// phpcs:ignore: WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound

			// Include front end files.
			if ( ! is_admin() ) {
				require_once PHAST_THEME_HEADING_COLORS_DIR . 'dynamic-css/dynamic.css.php';// phpcs:ignore: WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
			}
		}
	}

	/**
	 *  Kicking this off by creating an object.
	 */
	new Phast_Heading_Colors();

}
