<?php
/**
 * Heading Colors Options for Phast theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 2.1.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Heading_Colors_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Heading_Colors_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Phast Heading Colors Settings.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 2.1.4
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				// Option: Base Heading Color.
				array(
					'default'   => '',
					'type'      => 'control',
					'control'   => 'ast-color',
					'transport' => 'postMessage',
					'priority'  => 18,
					'name'      => PHAST_THEME_SETTINGS . '[heading-base-color]',
					'title'     => __( 'Heading Color ( H1 - H6 )', 'phast' ),
					'section'   => 'section-colors-body',
				),

				/**
				 * Heading Typography starts here - h1 - h3
				 */

				/**
				 * Option: Heading <H1> Font Family
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[font-family-h1]',
					'type'      => 'control',
					'control'   => 'ast-font',
					'font-type' => 'ast-font-family',
					'default'   => phast_get_option( 'font-family-h1' ),
					'title'     => __( 'Family', 'phast' ),
					'section'   => 'section-content-typo',
					'priority'  => 5,
					'connect'   => PHAST_THEME_SETTINGS . '[font-weight-h1]',
					'transport' => 'postMessage',
				),

				/**
				 * Option: Heading <H1> Font Weight
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[font-weight-h1]',
					'type'              => 'control',
					'control'           => 'ast-font',
					'font-type'         => 'ast-font-weight',
					'title'             => __( 'Weight', 'phast' ),
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_font_weight' ),
					'default'           => phast_get_option( 'font-weight-h1' ),
					'section'           => 'section-content-typo',
					'priority'          => 7,
					'connect'           => PHAST_THEME_SETTINGS . '[font-family-h1]',
					'transport'         => 'postMessage',
				),

				/**
				 * Option: Heading <H1> Text Transform
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[text-transform-h1]',
					'section'   => 'section-content-typo',
					'default'   => phast_get_option( 'text-transform-h1' ),
					'title'     => __( 'Text Transform', 'phast' ),
					'type'      => 'control',
					'control'   => 'select',
					'priority'  => 8,
					'choices'   => array(
						''           => __( 'Inherit', 'phast' ),
						'none'       => __( 'None', 'phast' ),
						'capitalize' => __( 'Capitalize', 'phast' ),
						'uppercase'  => __( 'Uppercase', 'phast' ),
						'lowercase'  => __( 'Lowercase', 'phast' ),
					),
					'transport' => 'postMessage',
				),

				/**
				 * Option: Heading <H1> Line Height
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[line-height-h1]',
					'section'           => 'section-content-typo',
					'default'           => '',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_number_n_blank' ),
					'type'              => 'control',
					'control'           => 'ast-slider',
					'title'             => __( 'Line Height', 'phast' ),
					'transport'         => 'postMessage',
					'priority'          => 8,
					'suffix'            => '',
					'input_attrs'       => array(
						'min'  => 1,
						'step' => 0.01,
						'max'  => 5,
					),
					'transport'         => 'postMessage',
				),

				/**
				 * Option: Heading <H2> Font Family
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[font-family-h2]',
					'type'      => 'control',
					'control'   => 'ast-font',
					'font-type' => 'ast-font-family',
					'title'     => __( 'Family', 'phast' ),
					'default'   => phast_get_option( 'font-family-h2' ),
					'section'   => 'section-content-typo',
					'priority'  => 10,
					'connect'   => PHAST_THEME_SETTINGS . '[font-weight-h2]',
					'transport' => 'postMessage',
				),

				/**
				 * Option: Heading <H2> Font Weight
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[font-weight-h2]',
					'type'              => 'control',
					'control'           => 'ast-font',
					'font-type'         => 'ast-font-weight',
					'title'             => __( 'Weight', 'phast' ),
					'section'           => 'section-content-typo',
					'default'           => phast_get_option( 'font-weight-h2' ),
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_font_weight' ),
					'priority'          => 12,
					'connect'           => PHAST_THEME_SETTINGS . '[font-family-h2]',
					'transport'         => 'postMessage',
				),

				/**
				 * Option: Heading <H2> Text Transform
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[text-transform-h2]',
					'section'   => 'section-content-typo',
					'default'   => phast_get_option( 'text-transform-h2' ),
					'title'     => __( 'Text Transform', 'phast' ),
					'type'      => 'control',
					'control'   => 'select',
					'transport' => 'postMessage',
					'priority'  => 13,
					'choices'   => array(
						''           => __( 'Inherit', 'phast' ),
						'none'       => __( 'None', 'phast' ),
						'capitalize' => __( 'Capitalize', 'phast' ),
						'uppercase'  => __( 'Uppercase', 'phast' ),
						'lowercase'  => __( 'Lowercase', 'phast' ),
					),
					'transport' => 'postMessage',
				),

				/**
				 * Option: Heading <H2> Line Height
				 */

				array(
					'name'              => PHAST_THEME_SETTINGS . '[line-height-h2]',
					'section'           => 'section-content-typo',
					'type'              => 'control',
					'control'           => 'ast-slider',
					'default'           => '',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_number_n_blank' ),
					'transport'         => 'postMessage',
					'title'             => __( 'Line Height', 'phast' ),
					'priority'          => 14,
					'suffix'            => '',
					'input_attrs'       => array(
						'min'  => 1,
						'step' => 0.01,
						'max'  => 5,
					),
					'transport'         => 'postMessage',
				),

				/**
				 * Option: Heading <H3> Font Family
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[font-family-h3]',
					'type'      => 'control',
					'control'   => 'ast-font',
					'font-type' => 'ast-font-family',
					'default'   => phast_get_option( 'font-family-h3' ),
					'title'     => __( 'Family', 'phast' ),
					'section'   => 'section-content-typo',
					'priority'  => 15,
					'connect'   => PHAST_THEME_SETTINGS . '[font-weight-h3]',
					'transport' => 'postMessage',
				),

				/**
				 * Option: Heading <H3> Font Weight
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[font-weight-h3]',
					'type'              => 'control',
					'control'           => 'ast-font',
					'font-type'         => 'ast-font-weight',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_font_weight' ),
					'default'           => phast_get_option( 'font-weight-h3' ),
					'title'             => __( 'Weight', 'phast' ),
					'section'           => 'section-content-typo',
					'priority'          => 17,
					'connect'           => PHAST_THEME_SETTINGS . '[font-family-h3]',
					'transport'         => 'postMessage',
				),

				/**
				 * Option: Heading <H3> Text Transform
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[text-transform-h3]',
					'type'      => 'control',
					'section'   => 'section-content-typo',
					'title'     => __( 'Text Transform', 'phast' ),
					'default'   => phast_get_option( 'text-transform-h3' ),
					'transport' => 'postMessage',
					'control'   => 'select',
					'priority'  => 18,
					'choices'   => array(
						''           => __( 'Inherit', 'phast' ),
						'none'       => __( 'None', 'phast' ),
						'capitalize' => __( 'Capitalize', 'phast' ),
						'uppercase'  => __( 'Uppercase', 'phast' ),
						'lowercase'  => __( 'Lowercase', 'phast' ),
					),
					'transport' => 'postMessage',
				),

				/**
				 * Option: Heading <H3> Line Height
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[line-height-h3]',
					'type'              => 'control',
					'control'           => 'ast-slider',
					'section'           => 'section-content-typo',
					'title'             => __( 'Line Height', 'phast' ),
					'transport'         => 'postMessage',
					'default'           => '',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_number_n_blank' ),
					'priority'          => 19,
					'suffix'            => '',
					'input_attrs'       => array(
						'min'  => 1,
						'step' => 0.01,
						'max'  => 5,
					),
					'transport'         => 'postMessage',
				),

				/**
				 * Option: Button Typography Section
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[button-typography-styling-divider]',
					'type'     => 'control',
					'control'  => 'ast-heading',
					'section'  => 'section-buttons',
					'title'    => __( 'Typography', 'phast' ),
					'priority' => 25,
					'settings' => array(),
				),

				/**
				 * Option: Button Typography Heading
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[button-text-typography]',
					'default'   => phast_get_option( 'button-text-typography' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Button Text', 'phast' ),
					'section'   => 'section-buttons',
					'transport' => 'postMessage',
					'priority'  => 25,
				),

				/**
				 * Option: Button Font Family
				 */
				array(
					'name'      => 'font-family-button',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[button-text-typography]',
					'section'   => 'section-buttons',
					'control'   => 'ast-font',
					'font_type' => 'ast-font-family',
					'title'     => __( 'Family', 'phast' ),
					'default'   => phast_get_option( 'font-family-button' ),
					'connect'   => PHAST_THEME_SETTINGS . '[font-weight-button]',
					'priority'  => 1,
				),

				/**
				 * Option: Button Font Size
				 */
				array(
					'name'        => 'font-size-button',
					'transport'   => 'postMessage',
					'title'       => __( 'Size', 'phast' ),
					'type'        => 'sub-control',
					'parent'      => PHAST_THEME_SETTINGS . '[button-text-typography]',
					'section'     => 'section-buttons',
					'control'     => 'ast-responsive',
					'default'     => phast_get_option( 'font-size-button' ),
					'input_attrs' => array(
						'min' => 0,
					),
					'units'       => array(
						'px' => 'px',
						'em' => 'em',
					),
				),

				/**
				 * Option: Button Font Weight
				 */
				array(
					'name'              => 'font-weight-button',
					'type'              => 'sub-control',
					'parent'            => PHAST_THEME_SETTINGS . '[button-text-typography]',
					'section'           => 'section-buttons',
					'control'           => 'ast-font',
					'font_type'         => 'ast-font-weight',
					'title'             => __( 'Weight', 'phast' ),
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_font_weight' ),
					'default'           => phast_get_option( 'font-weight-button' ),
					'connect'           => 'font-family-button',
					'priority'          => 2,
				),

				/**
				 * Option: Button Text Transform
				 */
				array(
					'name'      => 'text-transform-button',
					'transport' => 'postMessage',
					'default'   => phast_get_option( 'text-transform-button' ),
					'title'     => __( 'Text Transform', 'phast' ),
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[button-text-typography]',
					'section'   => 'section-buttons',
					'control'   => 'ast-select',
					'priority'  => 3,
					'choices'   => array(
						''           => __( 'Inherit', 'phast' ),
						'none'       => __( 'None', 'phast' ),
						'capitalize' => __( 'Capitalize', 'phast' ),
						'uppercase'  => __( 'Uppercase', 'phast' ),
						'lowercase'  => __( 'Lowercase', 'phast' ),
					),
				),

				/**
				 * Option: Theme Button Line Height
				 */
				array(
					'name'              => 'theme-btn-line-height',
					'control'           => 'ast-slider',
					'transport'         => 'postMessage',
					'type'              => 'sub-control',
					'default'           => phast_get_option( 'theme-btn-line-height' ),
					'parent'            => PHAST_THEME_SETTINGS . '[button-text-typography]',
					'section'           => 'section-buttons',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_number_n_blank' ),
					'title'             => __( 'Line Height', 'phast' ),
					'suffix'            => '',
					'priority'          => 4,
					'input_attrs'       => array(
						'min'  => 1,
						'step' => 0.01,
						'max'  => 5,
					),
				),

				/**
				 * Option: Theme Button Line Height
				 */
				array(
					'name'              => 'theme-btn-letter-spacing',
					'control'           => 'ast-slider',
					'transport'         => 'postMessage',
					'type'              => 'sub-control',
					'default'           => '',
					'parent'            => PHAST_THEME_SETTINGS . '[button-text-typography]',
					'section'           => 'section-buttons',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_number_n_blank' ),
					'title'             => __( 'Letter Spacing', 'phast' ),
					'suffix'            => '',
					'priority'          => 5,
					'input_attrs'       => array(
						'min'  => 1,
						'step' => 1,
						'max'  => 100,
					),
				),

			);

			return array_merge( $configurations, $_configs );

		}
	}
}

new Phast_Heading_Colors_Configs();
