<?php
/**
 * Admin functions - Functions that add some functionality to WordPress admin panel
 *
 * @package Phast
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Register menus
 */
if ( ! function_exists( 'phast_register_menu_locations' ) ) {

	/**
	 * Register menus
	 *
	 * @since 1.0.0
	 */
	function phast_register_menu_locations() {

		/**
		 * Menus
		 */
		register_nav_menus(
			array(
				'primary'     => __( 'Primary Menu', 'phast' ),
				'footer_menu' => __( 'Footer Menu', 'phast' ),
			)
		);
	}
}

add_action( 'init', 'phast_register_menu_locations' );
