/**
 * Install Starter Templates
 *
 *
 * @since 1.2.4
 */

(function($){

	PhastThemeAdmin = {

		init: function()
		{
			this._bind();
		},


		/**
		 * Binds events for the Phast Theme.
		 *
		 * @since 1.0.0
		 * @access private
		 * @method _bind
		 */
		_bind: function()
		{
			$( document ).on('ast-after-plugin-active', PhastThemeAdmin._disableActivcationNotice );
			$( document ).on('click' , '.phast-install-recommended-plugin', PhastThemeAdmin._installNow );
			$( document ).on('click' , '.phast-activate-recommended-plugin', PhastThemeAdmin._activatePlugin);
			$( document ).on('click' , '.phast-deactivate-recommended-plugin', PhastThemeAdmin._deactivatePlugin);
			$( document ).on('wp-plugin-install-success' , PhastThemeAdmin._activatePlugin);
			$( document ).on('wp-plugin-install-error'   , PhastThemeAdmin._installError);
			$( document ).on('wp-plugin-installing'      , PhastThemeAdmin._pluginInstalling);
		},

		/**
		 * Plugin Installation Error.
		 */
		_installError: function( event, response ) {

			var $card = jQuery( '.phast-install-recommended-plugin' );

			$card
				.removeClass( 'button-primary' )
				.addClass( 'disabled' )
				.html( wp.updates.l10n.installFailedShort );
		},

		/**
		 * Installing Plugin
		 */
		_pluginInstalling: function(event, args) {
			event.preventDefault();

			var slug = args.slug;

			var $card = jQuery( '.phast-install-recommended-plugin' );
			var activatingText = phast.recommendedPluiginActivatingText;


			$card.each(function( index, element ) {
				element = jQuery( element );
				if ( element.data('slug') === slug ) {
					element.addClass('updating-message');
					element.html( activatingText );
				}
			});

		},

		/**
		 * Activate Success
		 */
		_activatePlugin: function( event, response ) {

			event.preventDefault();

			var $message = jQuery(event.target);
			var $init = $message.data('init');
			var activatedSlug; 

			if (typeof $init === 'undefined') {
				var $message = jQuery('.phast-install-recommended-plugin[data-slug=' + response.slug + ']');
				activatedSlug = response.slug;
			} else {
				activatedSlug = $init;
			}

			// Transform the 'Install' button into an 'Activate' button.
			var $init = $message.data('init');
			var activatingText = phast.recommendedPluiginActivatingText;
			var settingsLink = $message.data('settings-link');
			var settingsLinkText = phast.recommendedPluiginSettingsText;
			var deactivateText = phast.recommendedPluiginDeactivateText;
			var phastSitesLink = phast.phastSitesLink;
			var phastPluginRecommendedNonce = phast.phastPluginManagerNonce;

			$message.removeClass( 'install-now installed button-disabled updated-message' )
				.addClass('updating-message')
				.html( activatingText );

			// WordPress adds "Activate" button after waiting for 1000ms. So we will run our activation after that.
			setTimeout( function() {

				$.ajax({
					url: phast.ajaxUrl,
					type: 'POST',
					data: {
						'action'            : 'phast-sites-plugin-activate',
						'nonce'             : phastPluginRecommendedNonce,
						'init'              : $init,
					},
				})
				.done(function (result) {

					if( result.success ) {
						var output  = '<a href="#" class="phast-deactivate-recommended-plugin" data-init="'+ $init +'" data-settings-link="'+ settingsLink +'" data-settings-link-text="'+ deactivateText +'" aria-label="'+ deactivateText +'">'+ deactivateText +'</a>';
							output += ( typeof settingsLink === 'string' && settingsLink != 'undefined' ) ? '<a href="' + settingsLink +'" aria-label="'+ settingsLinkText +'">' + settingsLinkText +' </a>' : '';
							output += ( typeof settingsLink === undefined && settingsLink != undefined ) ? '<a href="' + settingsLink +'" aria-label="'+ settingsLinkText +'">' + settingsLinkText +' </a>' : '';

						$message.removeClass( 'phast-activate-recommended-plugin phast-install-recommended-plugin button button-primary install-now activate-now updating-message' );

						$message.parent('.ast-addon-link-wrapper').parent('.phast-recommended-plugin').addClass('active');
						$message.parents('.ast-addon-link-wrapper').html( output );

						var starterSitesRedirectionUrl = phastSitesLink + result.data.starter_template_slug;
						jQuery(document).trigger( 'ast-after-plugin-active', [starterSitesRedirectionUrl, activatedSlug] );

					} else {

						$message.removeClass( 'updating-message' );
					}

				});

			}, 1200 );

		},

		/**
		 * Activate Success
		 */
		_deactivatePlugin: function( event, response ) {

			event.preventDefault();

			var $message = jQuery(event.target);

			var $init = $message.data('init');

			if (typeof $init === 'undefined') {
				var $message = jQuery('.phast-install-recommended-plugin[data-slug=' + response.slug + ']');
			}

			// Transform the 'Install' button into an 'Activate' button.
			var $init = $message.data('init');
			var deactivatingText = $message.data('deactivating-text') || phast.recommendedPluiginDeactivatingText;
			var settingsLink = $message.data('settings-link');
			var activateText = phast.recommendedPluiginActivateText;
			var phastPluginRecommendedNonce = phast.phastPluginManagerNonce;

			$message.removeClass( 'install-now installed button-disabled updated-message' )
				.addClass('updating-message')
				.html( deactivatingText );

			// WordPress adds "Activate" button after waiting for 1000ms. So we will run our activation after that.
			setTimeout( function() {

				$.ajax({
					url: phast.ajaxUrl,
					type: 'POST',
					data: {
						'action'            : 'phast-sites-plugin-deactivate',
						'nonce'             : phastPluginRecommendedNonce,
						'init'              : $init,
					},
				})
				.done(function (result) {

					if( result.success ) {
						var output = '<a href="#" class="phast-activate-recommended-plugin" data-init="'+ $init +'" data-settings-link="'+ settingsLink +'" data-settings-link-text="'+ activateText +'" aria-label="'+ activateText +'">'+ activateText +'</a>';
						$message.removeClass( 'phast-activate-recommended-plugin phast-install-recommended-plugin button button-primary install-now activate-now updating-message' );

						$message.parent('.ast-addon-link-wrapper').parent('.phast-recommended-plugin').removeClass('active');
						
						$message.parents('.ast-addon-link-wrapper').html( output );

					} else {

						$message.removeClass( 'updating-message' );

					}

				});

			}, 1200 );

		},

		/**
		 * Install Now
		 */
		_installNow: function(event)
		{
			event.preventDefault();

			var $button 	= jQuery( event.target ),
				$document   = jQuery(document);

			if ( $button.hasClass( 'updating-message' ) || $button.hasClass( 'button-disabled' ) ) {
				return;
			}

			if ( wp.updates.shouldRequestFilesystemCredentials && ! wp.updates.ajaxLocked ) {
				wp.updates.requestFilesystemCredentials( event );

				$document.on( 'credential-modal-cancel', function() {
					var $message = $( '.phast-install-recommended-plugin.updating-message' );

					$message
						.addClass('phast-activate-recommended-plugin')
						.removeClass( 'updating-message phast-install-recommended-plugin' )
						.text( wp.updates.l10n.installNow );

					wp.a11y.speak( wp.updates.l10n.updateCancel, 'polite' );
				} );
			}
			
			wp.updates.installPlugin( {
				slug:    $button.data( 'slug' )
			});
		},

		/**
		 * After plugin active redirect and deactivate activation notice
		 */
		_disableActivcationNotice: function( event, phastSitesLink, activatedSlug )
		{
			event.preventDefault();

			if ( activatedSlug.indexOf( 'phast-sites' ) >= 0 || activatedSlug.indexOf( 'phast-pro-sites' ) >= 0 ) {
				if ( 'undefined' != typeof PhastNotices ) {
			    	PhastNotices._ajax( 'phast-sites-on-active', '' );
				}
				window.location.href = phastSitesLink + '&ast-disable-activation-notice';
			}
		},
	};

	/**
	 * Initialize PhastThemeAdmin
	 */
	$(function(){
		PhastThemeAdmin.init();
	});

})(jQuery);