<?php
/**
 * Easy Digital Downloads Sidebar Options for our theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Edd_Sidebar_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Edd_Sidebar_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Phast Easy Digital Downloads Sidebar Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.5.5
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[edd-product-sidebar-layout-divider]',
					'section'  => 'section-sidebars',
					'type'     => 'control',
					'control'  => 'ast-divider',
					'priority' => 5,
					'settings' => array(),
				),

				/**
				 * Option: Shop Page
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[edd-sidebar-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'section-sidebars',
					'default'  => phast_get_option( 'edd-sidebar-layout' ),
					'priority' => 5,
					'title'    => __( 'Easy Digital Downloads', 'phast' ),
					'choices'  => array(
						'default'       => __( 'Default', 'phast' ),
						'no-sidebar'    => __( 'No Sidebar', 'phast' ),
						'left-sidebar'  => __( 'Left Sidebar', 'phast' ),
						'right-sidebar' => __( 'Right Sidebar', 'phast' ),
					),
				),

				/**
				 * Option: Single Product
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[edd-single-product-sidebar-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'default'  => phast_get_option( 'edd-single-product-sidebar-layout' ),
					'section'  => 'section-sidebars',
					'priority' => 5,
					'title'    => __( 'EDD Single Product', 'phast' ),
					'choices'  => array(
						'default'       => __( 'Default', 'phast' ),
						'no-sidebar'    => __( 'No Sidebar', 'phast' ),
						'left-sidebar'  => __( 'Left Sidebar', 'phast' ),
						'right-sidebar' => __( 'Right Sidebar', 'phast' ),
					),
				),
			);

			return array_merge( $configurations, $_configs );

		}
	}
}

new Phast_Edd_Sidebar_Configs();



