<?php
/**
 * Easy Digital Downloads Options for Phast Theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Edd_Archive_Layout_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Edd_Archive_Layout_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Phast-Easy Digital Downloads Shop Layout Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.5.5
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Shop Columns
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[edd-archive-grids]',
					'type'        => 'control',
					'control'     => 'ast-responsive-slider',
					'section'     => 'section-edd-archive',
					'default'     => array(
						'desktop' => 4,
						'tablet'  => 3,
						'mobile'  => 2,
					),
					'priority'    => 10,
					'title'       => __( 'Archive Columns', 'phast' ),
					'input_attrs' => array(
						'step' => 1,
						'min'  => 1,
						'max'  => 6,
					),
				),

				/**
				 * Option: EDD Archive Post Meta
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[edd-archive-product-structure]',
					'type'     => 'control',
					'control'  => 'ast-sortable',
					'section'  => 'section-edd-archive',
					'default'  => phast_get_option( 'edd-archive-product-structure' ),
					'priority' => 30,
					'title'    => __( 'Product Structure', 'phast' ),
					'choices'  => array(
						'image'      => __( 'Image', 'phast' ),
						'category'   => __( 'Category', 'phast' ),
						'title'      => __( 'Title', 'phast' ),
						'price'      => __( 'Price', 'phast' ),
						'short_desc' => __( 'Short Description', 'phast' ),
						'add_cart'   => __( 'Add To Cart', 'phast' ),
					),
				),

				/**
				 * Option: Add to Cart button text
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[edd-archive-add-to-cart-button-text]',
					'type'     => 'control',
					'control'  => 'text',
					'section'  => 'section-edd-archive',
					'default'  => phast_get_option( 'edd-archive-add-to-cart-button-text' ),
					'required' => array( PHAST_THEME_SETTINGS . '[edd-archive-product-structure]', 'contains', 'add_cart' ),
					'priority' => 31,
					'title'    => __( 'Cart Button Text', 'phast' ),
				),

				/**
				 * Option: Variable product button
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[edd-archive-variable-button]',
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'section-edd-archive',
					'default'  => phast_get_option( 'edd-archive-variable-button' ),
					'required' => array( PHAST_THEME_SETTINGS . '[edd-archive-product-structure]', 'contains', 'add_cart' ),
					'priority' => 31,
					'title'    => __( 'Variable Product Button', 'phast' ),
					'choices'  => array(
						'button'  => __( 'Button', 'phast' ),
						'options' => __( 'Options', 'phast' ),
					),
				),

				/**
				 * Option: Variable product button text
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[edd-archive-variable-button-text]',
					'type'     => 'control',
					'control'  => 'text',
					'section'  => 'section-edd-archive',
					'default'  => phast_get_option( 'edd-archive-variable-button-text' ),
					'required' => array( PHAST_THEME_SETTINGS . '[edd-archive-variable-button]', '==', 'button' ),
					'priority' => 31,
					'title'    => __( 'Variable Product Button Text', 'phast' ),
				),

				/**
				 * Option: Easy Digital Downloads Shop Archive Content Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[edd-archive-width-divider]',
					'type'     => 'control',
					'control'  => 'ast-divider',
					'section'  => 'section-edd-archive',
					'priority' => 220,
					'settings' => array(),
				),

				/**
				 * Option: Archive Content Width
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[edd-archive-width]',
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'section-edd-archive',
					'default'  => phast_get_option( 'edd-archive-width' ),
					'priority' => 220,
					'title'    => __( 'Archive Content Width', 'phast' ),
					'choices'  => array(
						'default' => __( 'Default', 'phast' ),
						'custom'  => __( 'Custom', 'phast' ),
					),
				),

				/**
				 * Option: Enter Width
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[edd-archive-max-width]',
					'type'        => 'control',
					'control'     => 'ast-slider',
					'section'     => 'section-edd-archive',
					'default'     => 1200,
					'priority'    => 225,
					'required'    => array( PHAST_THEME_SETTINGS . '[edd-archive-width]', '===', 'custom' ),
					'title'       => __( 'Custom Width', 'phast' ),
					'transport'   => 'postMessage',
					'suffix'      => '',
					'input_attrs' => array(
						'min'  => 768,
						'step' => 1,
						'max'  => 1920,
					),
				),
			);

			$configurations = array_merge( $configurations, $_configs );

			return $configurations;

		}
	}
}

new Phast_Edd_Archive_Layout_Configs();

