<?php
/**
 * Container Options for Phast theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Learndash_Container_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Learndash_Container_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register LearnDash Container settings.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[learndash-content-divider]',
					'type'     => 'control',
					'section'  => 'section-container-layout',
					'control'  => 'ast-divider',
					'priority' => 68,
					'settings' => array(),
				),

				/**
				 * Option: Shop Page
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[learndash-content-layout]',
					'type'        => 'control',
					'control'     => 'select',
					'section'     => 'section-container-layout',
					'default'     => phast_get_option( 'learndash-content-layout' ),
					'priority'    => 68,
					'title'       => __( 'LearnDash Layout', 'phast' ),
					'description' => __( 'Will be applied to All Single Courses, Topics, Lessons and Quizzes. Does not work on pages created with LearnDash shortcodes.', 'phast' ),
					'choices'     => array(
						'default'                 => __( 'Default', 'phast' ),
						'boxed-container'         => __( 'Boxed', 'phast' ),
						'content-boxed-container' => __( 'Content Boxed', 'phast' ),
						'plain-container'         => __( 'Full Width / Contained', 'phast' ),
						'page-builder'            => __( 'Full Width / Stretched', 'phast' ),
					),
				),
			);

			return array_merge( $configurations, $_configs );

		}
	}
}

new Phast_Learndash_Container_Configs();
