<?php
/**
 * Content Spacing Options for our theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       1.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Learndash_Sidebar_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Learndash_Sidebar_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register LearnDash Sidebar settings.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[learndash-sidebar-layout-divider]',
					'type'     => 'control',
					'section'  => 'section-sidebars',
					'control'  => 'ast-divider',
					'priority' => 5,
					'settings' => array(),
				),

				/**
				 * Option: LearnDash
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[learndash-sidebar-layout]',
					'type'        => 'control',
					'control'     => 'select',
					'section'     => 'section-sidebars',
					'default'     => phast_get_option( 'learndash-sidebar-layout' ),
					'priority'    => 5,
					'title'       => __( 'LearnDash', 'phast' ),
					'description' => __( 'This layout will apply on all single course, lesson, topic and quiz.', 'phast' ),
					'choices'     => array(
						'default'       => __( 'Default', 'phast' ),
						'no-sidebar'    => __( 'No Sidebar', 'phast' ),
						'left-sidebar'  => __( 'Left Sidebar', 'phast' ),
						'right-sidebar' => __( 'Right Sidebar', 'phast' ),
					),
				),
			);

			return array_merge( $configurations, $_configs );
		}
	}
}

new Phast_Learndash_Sidebar_Configs();
