<?php
/**
 * LifterLMS General Options for our theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Learndash_General_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Learndash_General_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register LearnDash General Layout settings.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Display Serial Number
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[learndash-lesson-serial-number]',
					'section'  => 'section-learndash',
					'type'     => 'control',
					'control'  => 'checkbox',
					'default'  => phast_get_option( 'learndash-lesson-serial-number' ),
					'title'    => __( 'Display Serial Number', 'phast' ),
					'priority' => 25,
				),

				/**
				 * Option: Differentiate Rows
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[learndash-differentiate-rows]',
					'default'  => phast_get_option( 'learndash-differentiate-rows' ),
					'type'     => 'control',
					'control'  => 'checkbox',
					'section'  => 'section-learndash',
					'title'    => __( 'Differentiate Rows', 'phast' ),
					'priority' => 30,
				),
			);

			return array_merge( $configurations, $_configs );

		}
	}
}

new Phast_Learndash_General_Configs();
