<?php
/**
 * Content Spacing Options for our theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Lifter_Sidebar_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Lifter_Sidebar_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Phast-LifterLMS Sidebar Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[lifterlms-course-lesson-sidebar-layout-divider]',
					'section'  => 'section-sidebars',
					'type'     => 'control',
					'control'  => 'ast-divider',
					'priority' => 5,
					'settings' => array(),
				),

				/**
				 * Option: Shop Page
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[lifterlms-sidebar-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'section-sidebars',
					'priority' => 5,
					'default'  => phast_get_option( 'lifterlms-sidebar-layout' ),
					'title'    => __( 'LifterLMS', 'phast' ),
					'choices'  => array(
						'default'       => __( 'Default', 'phast' ),
						'no-sidebar'    => __( 'No Sidebar', 'phast' ),
						'left-sidebar'  => __( 'Left Sidebar', 'phast' ),
						'right-sidebar' => __( 'Right Sidebar', 'phast' ),
					),
				),

				/**
				 * Option: LifterLMS Course/Lesson
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[lifterlms-course-lesson-sidebar-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'section-sidebars',
					'default'  => phast_get_option( 'lifterlms-course-lesson-sidebar-layout' ),
					'priority' => 5,
					'title'    => __( 'LifterLMS Course/Lesson', 'phast' ),
					'choices'  => array(
						'default'       => __( 'Default', 'phast' ),
						'no-sidebar'    => __( 'No Sidebar', 'phast' ),
						'left-sidebar'  => __( 'Left Sidebar', 'phast' ),
						'right-sidebar' => __( 'Right Sidebar', 'phast' ),
					),
				),
			);

			return array_merge( $configurations, $_configs );

		}
	}
}

new Phast_Lifter_Sidebar_Configs();
