<?php
/**
 * Container Options for Phast theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Woo_Shop_Container_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Woo_Shop_Container_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Phast-WooCommerce Shop Container Settings.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[woocommerce-content-divider]',
					'type'     => 'control',
					'section'  => 'section-container-layout',
					'control'  => 'ast-divider',
					'priority' => 85,
					'settings' => array(),
				),

				/**
				 * Option: Shop Page
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[woocommerce-content-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'default'  => phast_get_option( 'woocommerce-content-layout' ),
					'section'  => 'section-container-layout',
					'priority' => 85,
					'title'    => __( 'WooCommerce Layout', 'phast' ),
					'choices'  => array(
						'default'                 => __( 'Default', 'phast' ),
						'boxed-container'         => __( 'Boxed', 'phast' ),
						'content-boxed-container' => __( 'Content Boxed', 'phast' ),
						'plain-container'         => __( 'Full Width / Contained', 'phast' ),
						'page-builder'            => __( 'Full Width / Stretched', 'phast' ),
					),
				),
			);

			return array_merge( $configurations, $_configs );

		}
	}
}

new Phast_Woo_Shop_Container_Configs();

