<?php
/**
 * WooCommerce Options for Phast Theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Woo_Shop_Layout_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Woo_Shop_Layout_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Phast-WooCommerce Shop Layout Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Shop Columns
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[shop-grids]',
					'type'        => 'control',
					'control'     => 'ast-responsive-slider',
					'section'     => 'woocommerce_product_catalog',
					'default'     => array(
						'desktop' => 4,
						'tablet'  => 3,
						'mobile'  => 2,
					),
					'priority'    => 11,
					'title'       => __( 'Shop Columns', 'phast' ),
					'input_attrs' => array(
						'step' => 1,
						'min'  => 1,
						'max'  => 6,
					),
				),

				/**
				 * Option: Products Per Page
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[shop-no-of-products]',
					'type'        => 'control',
					'section'     => 'woocommerce_product_catalog',
					'title'       => __( 'Products Per Page', 'phast' ),
					'default'     => phast_get_option( 'shop-no-of-products' ),
					'control'     => 'number',
					'priority'    => 15,
					'input_attrs' => array(
						'min'  => 1,
						'step' => 1,
						'max'  => 100,
					),
				),

				/**
				 * Option: Single Post Meta
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[shop-product-structure]',
					'type'     => 'control',
					'control'  => 'ast-sortable',
					'section'  => 'woocommerce_product_catalog',
					'default'  => phast_get_option( 'shop-product-structure' ),
					'priority' => 15,
					'title'    => __( 'Shop Product Structure', 'phast' ),
					'choices'  => array(
						'title'      => __( 'Title', 'phast' ),
						'price'      => __( 'Price', 'phast' ),
						'ratings'    => __( 'Ratings', 'phast' ),
						'short_desc' => __( 'Short Description', 'phast' ),
						'add_cart'   => __( 'Add To Cart', 'phast' ),
						'category'   => __( 'Category', 'phast' ),
					),
				),

				/**
				 * Option: Shop Archive Content Width
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[shop-archive-width]',
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'woocommerce_product_catalog',
					'default'  => phast_get_option( 'shop-archive-width' ),
					'priority' => 10,
					'title'    => __( 'Shop Archive Content Width', 'phast' ),
					'choices'  => array(
						'default' => __( 'Default', 'phast' ),
						'custom'  => __( 'Custom', 'phast' ),
					),
				),

				/**
				 * Option: Enter Width
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[shop-archive-max-width]',
					'type'        => 'control',
					'control'     => 'ast-slider',
					'section'     => 'woocommerce_product_catalog',
					'default'     => 1200,
					'priority'    => 10,
					'required'    => array( PHAST_THEME_SETTINGS . '[shop-archive-width]', '===', 'custom' ),
					'title'       => __( 'Custom Width', 'phast' ),
					'transport'   => 'postMessage',
					'suffix'      => '',
					'input_attrs' => array(
						'min'  => 768,
						'step' => 1,
						'max'  => 1920,
					),
				),
			);

			$configurations = array_merge( $configurations, $_configs );

			return $configurations;

		}
	}
}

new Phast_Woo_Shop_Layout_Configs();

