<?php
/**
 * WooCommerce Options for Phast Theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Woo_Shop_Single_Layout_Configs' ) ) {


	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Woo_Shop_Single_Layout_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Phast-WooCommerce Shop Single Layout Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				* Option: Disable Breadcrumb
				*/
				array(
					'name'     => PHAST_THEME_SETTINGS . '[single-product-breadcrumb-disable]',
					'section'  => 'section-woo-shop-single',
					'type'     => 'control',
					'control'  => 'checkbox',
					'default'  => phast_get_option( 'single-product-breadcrumb-disable' ),
					'title'    => __( 'Disable Breadcrumb', 'phast' ),
					'priority' => 16,
				),

				/**
				 * Option: Disable Transparent Header on WooCommerce Product pages
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[transparent-header-disable-woo-products]',
					'default'  => phast_get_option( 'transparent-header-disable-woo-products' ),
					'type'     => 'control',
					'section'  => 'section-transparent-header',
					'title'    => __( 'Disable on WooCommerce Product Pages?', 'phast' ),
					'required' => array( PHAST_THEME_SETTINGS . '[transparent-header-enable]', '==', '1' ),
					'priority' => 26,
					'control'  => 'checkbox',
				),
			);

			return array_merge( $configurations, $_configs );

		}
	}
}

new Phast_Woo_Shop_Single_Layout_Configs();


