<?php
/**
 * Phast Theme Strings
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Default Strings
 */
if ( ! function_exists( 'phast_default_strings' ) ) {

	/**
	 * Default Strings
	 *
	 * @since 1.0.0
	 * @param  string  $key  String key.
	 * @param  boolean $echo Print string.
	 * @return mixed        Return string or nothing.
	 */
	function phast_default_strings( $key, $echo = true ) {

		$defaults = apply_filters(
			'phast_default_strings',
			array(

				// Header.
				'string-header-skip-link'                => __( 'Skip to content', 'phast' ),

				// 404 Page Strings.
				'string-404-sub-title'                   => __( 'It looks like the link pointing here was faulty. Maybe try searching?', 'phast' ),

				// Search Page Strings.
				'string-search-nothing-found'            => __( 'Nothing Found', 'phast' ),
				'string-search-nothing-found-message'    => __( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'phast' ),
				'string-full-width-search-message'       => __( 'Start typing and press enter to search', 'phast' ),
				'string-full-width-search-placeholder'   => __( 'Search &hellip;', 'phast' ),
				'string-header-cover-search-placeholder' => __( 'Search &hellip;', 'phast' ),
				'string-search-input-placeholder'        => __( 'Search &hellip;', 'phast' ),

				// Comment Template Strings.
				'string-comment-reply-link'              => __( 'Reply', 'phast' ),
				'string-comment-edit-link'               => __( 'Edit', 'phast' ),
				'string-comment-awaiting-moderation'     => __( 'Your comment is awaiting moderation.', 'phast' ),
				'string-comment-title-reply'             => __( 'Leave a Comment', 'phast' ),
				'string-comment-cancel-reply-link'       => __( 'Cancel Reply', 'phast' ),
				'string-comment-label-submit'            => __( 'Post Comment &raquo;', 'phast' ),
				'string-comment-label-message'           => __( 'Type here..', 'phast' ),
				'string-comment-label-name'              => __( 'Name*', 'phast' ),
				'string-comment-label-email'             => __( 'Email*', 'phast' ),
				'string-comment-label-website'           => __( 'Website', 'phast' ),
				'string-comment-closed'                  => __( 'Comments are closed.', 'phast' ),
				'string-comment-navigation-title'        => __( 'Comment navigation', 'phast' ),
				'string-comment-navigation-next'         => __( 'Newer Comments', 'phast' ),
				'string-comment-navigation-previous'     => __( 'Older Comments', 'phast' ),

				// Blog Default Strings.
				'string-blog-page-links-before'          => __( 'Pages:', 'phast' ),
				'string-blog-meta-author-by'             => __( 'By ', 'phast' ),
				'string-blog-meta-leave-a-comment'       => __( 'Leave a Comment', 'phast' ),
				'string-blog-meta-one-comment'           => __( '1 Comment', 'phast' ),
				'string-blog-meta-multiple-comment'      => __( '% Comments', 'phast' ),
				'string-blog-navigation-next'            => __( 'Next Page', 'phast' ) . ' <span class="ast-right-arrow">&rarr;</span>',
				'string-blog-navigation-previous'        => '<span class="ast-left-arrow">&larr;</span> ' . __( 'Previous Page', 'phast' ),

				// Single Post Default Strings.
				'string-single-page-links-before'        => __( 'Pages:', 'phast' ),
				/* translators: 1: Post type label */
				'string-single-navigation-next'          => __( 'Next %s', 'phast' ) . ' <span class="ast-right-arrow">&rarr;</span>',
				/* translators: 1: Post type label */
				'string-single-navigation-previous'      => '<span class="ast-left-arrow">&larr;</span> ' . __( 'Previous %s', 'phast' ),

				// Content None.
				'string-content-nothing-found-message'   => __( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'phast' ),

			)
		);

		if ( is_rtl() ) {
			$defaults['string-blog-navigation-next']     = __( 'Next Page', 'phast' ) . ' <span class="ast-left-arrow">&larr;</span>';
			$defaults['string-blog-navigation-previous'] = '<span class="ast-right-arrow">&rarr;</span> ' . __( 'Previous Page', 'phast' );

			/* translators: 1: Post type label */
			$defaults['string-single-navigation-next'] = __( 'Next %s', 'phast' ) . ' <span class="ast-left-arrow">&larr;</span>';
			/* translators: 1: Post type label */
			$defaults['string-single-navigation-previous'] = '<span class="ast-right-arrow">&rarr;</span> ' . __( 'Previous %s', 'phast' );
		}

		$output = isset( $defaults[ $key ] ) ? $defaults[ $key ] : '';

		/**
		 * Print or return
		 */
		if ( $echo ) {
			echo $output; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		} else {
			return $output;
		}
	}
}
