<?php
/**
 * Theme Hook Alliance hook stub list.
 *
 * @see  https://github.com/zamoose/themehookalliance
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Themes and Plugins can check for phast_hooks using current_theme_supports( 'phast_hooks', $hook )
 * to determine whether a theme declares itself to support this specific hook type.
 *
 * Example:
 * <code>
 *      // Declare support for all hook types
 *      add_theme_support( 'phast_hooks', array( 'all' ) );
 *
 *      // Declare support for certain hook types only
 *      add_theme_support( 'phast_hooks', array( 'header', 'content', 'footer' ) );
 * </code>
 */
add_theme_support(
	'phast_hooks',
	array(

		/**
		 * As a Theme developer, use the 'all' parameter, to declare support for all
		 * hook types.
		 * Please make sure you then actually reference all the hooks in this file,
		 * Plugin developers depend on it!
		 */
		'all',

		/**
		 * Themes can also choose to only support certain hook types.
		 * Please make sure you then actually reference all the hooks in this type
		 * family.
		 *
		 * When the 'all' parameter was set, specific hook types do not need to be
		 * added explicitly.
		 */
		'html',
		'body',
		'head',
		'header',
		'content',
		'entry',
		'comments',
		'sidebars',
		'sidebar',
		'footer',

	/**
	 * If/when WordPress Core implements similar methodology, Themes and Plugins
	 * will be able to check whether the version of THA supplied by the theme
	 * supports Core hooks.
	 */
	)
);

/**
 * Determines, whether the specific hook type is actually supported.
 *
 * Plugin developers should always check for the support of a <strong>specific</strong>
 * hook type before hooking a callback function to a hook of this type.
 *
 * Example:
 * <code>
 *      if ( current_theme_supports( 'phast_hooks', 'header' ) )
 *          add_action( 'phast_head_top', 'prefix_header_top' );
 * </code>
 *
 * @param bool  $bool true.
 * @param array $args The hook type being checked.
 * @param array $registered All registered hook types.
 *
 * @return bool
 */
function phast_current_theme_supports( $bool, $args, $registered ) {
	return in_array( $args[0], $registered[0] ) || in_array( 'all', $registered[0] );
}
add_filter( 'current_theme_supports-phast_hooks', 'phast_current_theme_supports', 10, 3 );

/**
 * HTML <html> hook
 * Special case, useful for <DOCTYPE>, etc.
 * $phast_supports[] = 'html;
 */
function phast_html_before() {
	do_action( 'phast_html_before' );
}
/**
 * HTML <body> hooks
 * $phast_supports[] = 'body';
 */
function phast_body_top() {
	do_action( 'phast_body_top' );
}

/**
 * Body Bottom
 */
function phast_body_bottom() {
	do_action( 'phast_body_bottom' );
}

/**
 * HTML <head> hooks
 *
 * $phast_supports[] = 'head';
 */
function phast_head_top() {
	do_action( 'phast_head_top' );
}

/**
 * Head Bottom
 */
function phast_head_bottom() {
	do_action( 'phast_head_bottom' );
}

/**
 * Semantic <header> hooks
 *
 * $phast_supports[] = 'header';
 */
function phast_header_before() {
	do_action( 'phast_header_before' );
}

/**
 * Site Header
 */
function phast_header() {
	do_action( 'phast_header' );
}

/**
 * Masthead Top
 */
function phast_masthead_top() {
	do_action( 'phast_masthead_top' );
}

/**
 * Masthead
 */
function phast_masthead() {
	do_action( 'phast_masthead' );
}

/**
 * Masthead Bottom
 */
function phast_masthead_bottom() {
	do_action( 'phast_masthead_bottom' );
}

/**
 * Header After
 */
function phast_header_after() {
	do_action( 'phast_header_after' );
}

/**
 * Main Header bar top
 */
function phast_main_header_bar_top() {
	do_action( 'phast_main_header_bar_top' );
}

/**
 * Main Header bar bottom
 */
function phast_main_header_bar_bottom() {
	do_action( 'phast_main_header_bar_bottom' );
}

/**
 * Main Header Content
 */
function phast_masthead_content() {
	do_action( 'phast_masthead_content' );
}
/**
 * Main toggle button before
 */
function phast_masthead_toggle_buttons_before() {
	do_action( 'phast_masthead_toggle_buttons_before' );
}

/**
 * Main toggle buttons
 */
function phast_masthead_toggle_buttons() {
	do_action( 'phast_masthead_toggle_buttons' );
}

/**
 * Main toggle button after
 */
function phast_masthead_toggle_buttons_after() {
	do_action( 'phast_masthead_toggle_buttons_after' );
}

/**
 * Semantic <content> hooks
 *
 * $phast_supports[] = 'content';
 */
function phast_content_before() {
	do_action( 'phast_content_before' );
}

/**
 * Content after
 */
function phast_content_after() {
	do_action( 'phast_content_after' );
}

/**
 * Content top
 */
function phast_content_top() {
	do_action( 'phast_content_top' );
}

/**
 * Content bottom
 */
function phast_content_bottom() {
	do_action( 'phast_content_bottom' );
}

/**
 * Content while before
 */
function phast_content_while_before() {
	do_action( 'phast_content_while_before' );
}

/**
 * Content loop
 */
function phast_content_loop() {
	do_action( 'phast_content_loop' );
}

/**
 * Conten Page Loop.
 *
 * Called from page.php
 */
function phast_content_page_loop() {
	do_action( 'phast_content_page_loop' );
}

/**
 * Content while after
 */
function phast_content_while_after() {
	do_action( 'phast_content_while_after' );
}

/**
 * Semantic <entry> hooks
 *
 * $phast_supports[] = 'entry';
 */
function phast_entry_before() {
	do_action( 'phast_entry_before' );
}

/**
 * Entry after
 */
function phast_entry_after() {
	do_action( 'phast_entry_after' );
}

/**
 * Entry content before
 */
function phast_entry_content_before() {
	do_action( 'phast_entry_content_before' );
}

/**
 * Entry content after
 */
function phast_entry_content_after() {
	do_action( 'phast_entry_content_after' );
}

/**
 * Entry Top
 */
function phast_entry_top() {
	do_action( 'phast_entry_top' );
}

/**
 * Entry bottom
 */
function phast_entry_bottom() {
	do_action( 'phast_entry_bottom' );
}

/**
 * Single Post Header Before
 */
function phast_single_header_before() {
	do_action( 'phast_single_header_before' );
}

/**
 * Single Post Header After
 */
function phast_single_header_after() {
	do_action( 'phast_single_header_after' );
}

/**
 * Single Post Header Top
 */
function phast_single_header_top() {
	do_action( 'phast_single_header_top' );
}

/**
 * Single Post Header Bottom
 */
function phast_single_header_bottom() {
	do_action( 'phast_single_header_bottom' );
}

/**
 * Comments block hooks
 *
 * $phast_supports[] = 'comments';
 */
function phast_comments_before() {
	do_action( 'phast_comments_before' );
}

/**
 * Comments after.
 */
function phast_comments_after() {
	do_action( 'phast_comments_after' );
}

/**
 * Semantic <sidebar> hooks
 *
 * $phast_supports[] = 'sidebar';
 */
function phast_sidebars_before() {
	do_action( 'phast_sidebars_before' );
}

/**
 * Sidebars after
 */
function phast_sidebars_after() {
	do_action( 'phast_sidebars_after' );
}

/**
 * Semantic <footer> hooks
 *
 * $phast_supports[] = 'footer';
 */
function phast_footer() {
	do_action( 'phast_footer' );
}

/**
 * Footer before
 */
function phast_footer_before() {
	do_action( 'phast_footer_before' );
}

/**
 * Footer after
 */
function phast_footer_after() {
	do_action( 'phast_footer_after' );
}

/**
 * Footer top
 */
function phast_footer_content_top() {
	do_action( 'phast_footer_content_top' );
}

/**
 * Footer
 */
function phast_footer_content() {
	do_action( 'phast_footer_content' );
}

/**
 * Footer bottom
 */
function phast_footer_content_bottom() {
	do_action( 'phast_footer_content_bottom' );
}

/**
 * Archive header
 */
function phast_archive_header() {
	do_action( 'phast_archive_header' );
}

/**
 * Pagination
 */
function phast_pagination() {
	do_action( 'phast_pagination' );
}

/**
 * Entry content single
 */
function phast_entry_content_single() {
	do_action( 'phast_entry_content_single' );
}

/**
 * 404
 */
function phast_entry_content_404_page() {
	do_action( 'phast_entry_content_404_page' );
}

/**
 * Entry content blog
 */
function phast_entry_content_blog() {
	do_action( 'phast_entry_content_blog' );
}

/**
 * Blog featured post section
 */
function phast_blog_post_featured_format() {
	do_action( 'phast_blog_post_featured_format' );
}

/**
 * Primary Content Top
 */
function phast_primary_content_top() {
	do_action( 'phast_primary_content_top' );
}

/**
 * Primary Content Bottom
 */
function phast_primary_content_bottom() {
	do_action( 'phast_primary_content_bottom' );
}

/**
 * 404 Page content template action.
 */
function phast_404_content_template() {
	do_action( 'phast_404_content_template' );
}

if ( ! function_exists( 'wp_body_open' ) ) {

	/**
	 * Fire the wp_body_open action.
	 * Adds backward compatibility for WordPress versions < 5.2
	 *
	 * @since 1.8.7
	 */
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
}
