<?php
/**
 * Phast Theme Customizer Configuration Base.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

// No direct access, please.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Customizer Sanitizes
 *
 * @since 1.4.3
 */
if ( ! class_exists( 'Phast_Customizer_Button_Configs' ) ) {

	/**
	 * Register Button Customizer Configurations.
	 */
	class Phast_Customizer_Button_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Button Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				array(
					'name'     => PHAST_THEME_SETTINGS . '[button-color-styling-divider]',
					'type'     => 'control',
					'control'  => 'ast-heading',
					'section'  => 'section-buttons',
					'title'    => __( 'Colors and Border', 'phast' ),
					'priority' => 17,
					'settings' => array(),
				),
				/**
				 * Group: Theme Button Colors Group
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[theme-button-color-group]',
					'default'   => phast_get_option( 'theme-button-color-group' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Color', 'phast' ),
					'section'   => 'section-buttons',
					'transport' => 'postMessage',
					'priority'  => 18,
				),

				/**
				 * Group: Theme Button Border Group
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[theme-button-border-group]',
					'default'   => phast_get_option( 'theme-button-border-group' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Border', 'phast' ),
					'section'   => 'section-buttons',
					'transport' => 'postMessage',
					'priority'  => 19,
				),

				/**
				 * Option: Button Color
				 */
				array(
					'name'    => 'button-color',
					'default' => '',
					'type'    => 'sub-control',
					'parent'  => PHAST_THEME_SETTINGS . '[theme-button-color-group]',
					'section' => 'section-buttons',
					'tab'     => __( 'Normal', 'phast' ),
					'control' => 'ast-color',
					'title'   => __( 'Text Color', 'phast' ),
				),

				/**
				 * Option: Button Hover Color
				 */
				array(
					'name'    => 'button-h-color',
					'default' => '',
					'type'    => 'sub-control',
					'parent'  => PHAST_THEME_SETTINGS . '[theme-button-color-group]',
					'section' => 'section-buttons',
					'tab'     => __( 'Hover', 'phast' ),
					'control' => 'ast-color',
					'title'   => __( 'Text Color', 'phast' ),
				),

				/**
				 * Option: Button Background Color
				 */
				array(
					'name'    => 'button-bg-color',
					'default' => '',
					'type'    => 'sub-control',
					'parent'  => PHAST_THEME_SETTINGS . '[theme-button-color-group]',
					'section' => 'section-buttons',
					'tab'     => __( 'Normal', 'phast' ),
					'control' => 'ast-color',
					'title'   => __( 'Background Color', 'phast' ),
				),

				/**
				 * Option: Button Background Hover Color
				 */
				array(
					'name'    => 'button-bg-h-color',
					'default' => '',
					'type'    => 'sub-control',
					'parent'  => PHAST_THEME_SETTINGS . '[theme-button-color-group]',
					'section' => 'section-buttons',
					'tab'     => __( 'Hover', 'phast' ),
					'control' => 'ast-color',
					'title'   => __( 'Background Color', 'phast' ),
				),

				/**
				 * Option: Global Button Border Size
				 */
				array(
					'type'           => 'sub-control',
					'parent'         => PHAST_THEME_SETTINGS . '[theme-button-border-group]',
					'section'        => 'section-buttons',
					'control'        => 'ast-border',
					'name'           => 'theme-button-border-group-border-size',
					'transport'      => 'postMessage',
					'linked_choices' => true,
					'priority'       => 10,
					'default'        => phast_get_option( 'theme-button-border-group-border-size' ),
					'title'          => __( 'Width', 'phast' ),
					'choices'        => array(
						'top'    => __( 'Top', 'phast' ),
						'right'  => __( 'Right', 'phast' ),
						'bottom' => __( 'Bottom', 'phast' ),
						'left'   => __( 'Left', 'phast' ),
					),
				),

				/**
				 * Option: Global Button Border Color
				 */
				array(
					'name'      => 'theme-button-border-group-border-color',
					'default'   => phast_get_option( 'theme-button-border-group-border-color' ),
					'transport' => 'postMessage',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[theme-button-border-group]',
					'section'   => 'section-buttons',
					'control'   => 'ast-color',
					'priority'  => 12,
					'title'     => __( 'Color', 'phast' ),
				),

				/**
				 * Option: Global Button Border Hover Color
				 */
				array(
					'name'      => 'theme-button-border-group-border-h-color',
					'default'   => phast_get_option( 'theme-button-border-group-border-h-color' ),
					'transport' => 'postMessage',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[theme-button-border-group]',
					'section'   => 'section-buttons',
					'control'   => 'ast-color',
					'priority'  => 14,
					'title'     => __( 'Hover Color', 'phast' ),
				),

				/**
				 * Option: Global Button Radius
				 */
				array(
					'name'        => 'button-radius',
					'default'     => phast_get_option( 'button-radius' ),
					'type'        => 'sub-control',
					'parent'      => PHAST_THEME_SETTINGS . '[theme-button-border-group]',
					'section'     => 'section-buttons',
					'control'     => 'ast-slider',
					'title'       => __( 'Border Radius', 'phast' ),
					'input_attrs' => array(
						'min'  => 0,
						'step' => 1,
						'max'  => 200,
					),
				),

				/**
				 * Option: Button Padding Section
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[button-padding-styling-divider]',
					'type'     => 'control',
					'control'  => 'ast-heading',
					'section'  => 'section-buttons',
					'title'    => __( 'Spacing', 'phast' ),
					'priority' => 30,
					'settings' => array(),
				),

				/**
				 * Option: Theme Button Padding
				 */
				array(
					'name'           => PHAST_THEME_SETTINGS . '[theme-button-padding]',
					'default'        => phast_get_option( 'theme-button-padding' ),
					'type'           => 'control',
					'control'        => 'ast-responsive-spacing',
					'section'        => 'section-buttons',
					'title'          => __( 'Padding', 'phast' ),
					'linked_choices' => true,
					'transport'      => 'postMessage',
					'unit_choices'   => array( 'px', 'em', '%' ),
					'choices'        => array(
						'top'    => __( 'Top', 'phast' ),
						'right'  => __( 'Right', 'phast' ),
						'bottom' => __( 'Bottom', 'phast' ),
						'left'   => __( 'Left', 'phast' ),
					),
					'priority'       => 35,
				),

				/**
				 * Option: Primary Header Button Colors Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[primary-header-button-color-divider]',
					'type'     => 'control',
					'control'  => 'ast-heading',
					'section'  => 'section-primary-menu',
					'title'    => __( 'Header Button', 'phast' ),
					'settings' => array(),
					'priority' => 17,
					'required' => array( PHAST_THEME_SETTINGS . '[header-main-rt-section-button-style]', '===', 'custom-button' ),
				),
				/**
				 * Group: Primary Header Button Colors Group
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[primary-header-button-color-group]',
					'default'   => phast_get_option( 'primary-header-button-color-group' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Colors', 'phast' ),
					'section'   => 'section-primary-menu',
					'transport' => 'postMessage',
					'priority'  => 18,
					'required'  => array( PHAST_THEME_SETTINGS . '[header-main-rt-section-button-style]', '===', 'custom-button' ),
				),
				/**
				 * Group: Primary Header Button Border Group
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[primary-header-button-border-group]',
					'default'   => phast_get_option( 'primary-header-button-border-group' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Border', 'phast' ),
					'section'   => 'section-primary-menu',
					'transport' => 'postMessage',
					'priority'  => 19,
					'required'  => array( PHAST_THEME_SETTINGS . '[header-main-rt-section-button-style]', '===', 'custom-button' ),
				),

				/**
				* Option: Button Text Color
				*/
				array(
					'name'      => 'header-main-rt-section-button-text-color',
					'transport' => 'postMessage',
					'default'   => phast_get_option( 'header-main-rt-section-button-text-color' ),
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[primary-header-button-color-group]',
					'section'   => 'section-primary-menu',
					'tab'       => __( 'Normal', 'phast' ),
					'control'   => 'ast-color',
					'priority'  => 10,
					'title'     => __( 'Text Color', 'phast' ),
				),

				/**
				* Option: Button Text Hover Color
				*/
				array(
					'name'      => 'header-main-rt-section-button-text-h-color',
					'default'   => phast_get_option( 'header-main-rt-section-button-text-h-color' ),
					'transport' => 'postMessage',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[primary-header-button-color-group]',
					'section'   => 'section-primary-menu',
					'tab'       => __( 'Hover', 'phast' ),
					'control'   => 'ast-color',
					'priority'  => 10,
					'title'     => __( 'Text Color', 'phast' ),
				),

				/**
				* Option: Button Background Color
				*/
				array(
					'name'      => 'header-main-rt-section-button-back-color',
					'default'   => phast_get_option( 'header-main-rt-section-button-back-color' ),
					'transport' => 'postMessage',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[primary-header-button-color-group]',
					'section'   => 'section-primary-menu',
					'tab'       => __( 'Normal', 'phast' ),
					'control'   => 'ast-color',
					'priority'  => 10,
					'title'     => __( 'Background Color', 'phast' ),
				),

				/**
				* Option: Button Button Hover Color
				*/
				array(
					'name'      => 'header-main-rt-section-button-back-h-color',
					'default'   => phast_get_option( 'header-main-rt-section-button-back-h-color' ),
					'transport' => 'postMessage',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[primary-header-button-color-group]',
					'section'   => 'section-primary-menu',
					'tab'       => __( 'Hover', 'phast' ),
					'control'   => 'ast-color',
					'priority'  => 10,
					'title'     => __( 'Background Color', 'phast' ),
				),

				/**
				 * Option: Primary Header Button Typography
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[primary-header-button-text-typography]',
					'default'   => phast_get_option( 'primary-header-button-text-typography' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Typography', 'phast' ),
					'section'   => 'section-primary-menu',
					'transport' => 'postMessage',
					'priority'  => 20,
					'required'  => array( PHAST_THEME_SETTINGS . '[header-main-rt-section-button-style]', '===', 'custom-button' ),
				),

				/**
				 * Option: Primary Header Button Font Family
				 */
				array(
					'name'      => 'primary-header-button-font-family',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[primary-header-button-text-typography]',
					'section'   => 'section-primary-menu',
					'control'   => 'ast-font',
					'font_type' => 'ast-font-family',
					'title'     => __( 'Family', 'phast' ),
					'default'   => phast_get_option( 'primary-header-button-font-family' ),
					'connect'   => PHAST_THEME_SETTINGS . '[primary-header-button-font-weight]',
					'priority'  => 1,
				),

				/**
				 * Option: Primary Header Button Font Size
				 */
				array(
					'name'        => 'primary-header-button-font-size',
					'transport'   => 'postMessage',
					'title'       => __( 'Size', 'phast' ),
					'type'        => 'sub-control',
					'parent'      => PHAST_THEME_SETTINGS . '[primary-header-button-text-typography]',
					'section'     => 'section-primary-menu',
					'control'     => 'ast-responsive',
					'default'     => phast_get_option( 'primary-header-button-font-size' ),
					'input_attrs' => array(
						'min' => 0,
					),
					'units'       => array(
						'px' => 'px',
						'em' => 'em',
					),
				),

				/**
				 * Option: Primary Header Button Font Weight
				 */
				array(
					'name'              => 'primary-header-button-font-weight',
					'type'              => 'sub-control',
					'parent'            => PHAST_THEME_SETTINGS . '[primary-header-button-text-typography]',
					'section'           => 'section-primary-menu',
					'control'           => 'ast-font',
					'font_type'         => 'ast-font-weight',
					'title'             => __( 'Weight', 'phast' ),
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_font_weight' ),
					'default'           => phast_get_option( 'primary-header-button-font-weight' ),
					'connect'           => 'primary-header-button-font-family',
					'priority'          => 2,
				),

				/**
				 * Option: Primary Header Button Text Transform
				 */
				array(
					'name'      => 'primary-header-button-text-transform',
					'transport' => 'postMessage',
					'default'   => phast_get_option( 'primary-header-button-text-transform' ),
					'title'     => __( 'Text Transform', 'phast' ),
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[primary-header-button-text-typography]',
					'section'   => 'section-primary-menu',
					'control'   => 'ast-select',
					'priority'  => 3,
					'choices'   => array(
						''           => __( 'Inherit', 'phast' ),
						'none'       => __( 'None', 'phast' ),
						'capitalize' => __( 'Capitalize', 'phast' ),
						'uppercase'  => __( 'Uppercase', 'phast' ),
						'lowercase'  => __( 'Lowercase', 'phast' ),
					),
				),

				/**
				 * Option: Primary Header Button Line Height
				 */
				array(
					'name'              => 'primary-header-button-line-height',
					'control'           => 'ast-slider',
					'transport'         => 'postMessage',
					'type'              => 'sub-control',
					'default'           => phast_get_option( 'primary-header-button-line-height' ),
					'parent'            => PHAST_THEME_SETTINGS . '[primary-header-button-text-typography]',
					'section'           => 'section-primary-menu',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_number_n_blank' ),
					'title'             => __( 'Line Height', 'phast' ),
					'suffix'            => '',
					'priority'          => 4,
					'input_attrs'       => array(
						'min'  => 1,
						'step' => 0.01,
						'max'  => 5,
					),
				),

				/**
				 * Option: Primary Header Button Letter Spacing
				 */
				array(
					'name'              => 'primary-header-button-letter-spacing',
					'control'           => 'ast-slider',
					'transport'         => 'postMessage',
					'type'              => 'sub-control',
					'default'           => '',
					'parent'            => PHAST_THEME_SETTINGS . '[primary-header-button-text-typography]',
					'section'           => 'section-primary-menu',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_number_n_blank' ),
					'title'             => __( 'Letter Spacing', 'phast' ),
					'suffix'            => '',
					'priority'          => 5,
					'input_attrs'       => array(
						'min'  => 1,
						'step' => 1,
						'max'  => 100,
					),
				),

				// Option: Custom Menu Button Border.
				array(
					'type'           => 'control',
					'control'        => 'ast-responsive-spacing',
					'name'           => PHAST_THEME_SETTINGS . '[header-main-rt-section-button-padding]',
					'section'        => 'section-primary-menu',
					'transport'      => 'postMessage',
					'linked_choices' => true,
					'priority'       => 21,
					'required'       => array( PHAST_THEME_SETTINGS . '[header-main-rt-section-button-style]', '===', 'custom-button' ),
					'default'        => phast_get_option( 'header-main-rt-section-button-padding' ),
					'title'          => __( 'Padding', 'phast' ),
					'choices'        => array(
						'top'    => __( 'Top', 'phast' ),
						'right'  => __( 'Right', 'phast' ),
						'bottom' => __( 'Bottom', 'phast' ),
						'left'   => __( 'Left', 'phast' ),
					),
				),

				/**
				* Option: Button Border Size
				*/
				array(
					'type'           => 'sub-control',
					'parent'         => PHAST_THEME_SETTINGS . '[primary-header-button-border-group]',
					'section'        => 'section-primary-menu',
					'control'        => 'ast-border',
					'name'           => 'header-main-rt-section-button-border-size',
					'transport'      => 'postMessage',
					'linked_choices' => true,
					'priority'       => 10,
					'default'        => phast_get_option( 'header-main-rt-section-button-border-size' ),
					'title'          => __( 'Width', 'phast' ),
					'choices'        => array(
						'top'    => __( 'Top', 'phast' ),
						'right'  => __( 'Right', 'phast' ),
						'bottom' => __( 'Bottom', 'phast' ),
						'left'   => __( 'Left', 'phast' ),
					),
				),

				/**
				* Option: Button Border Color
				*/
				array(
					'name'      => 'header-main-rt-section-button-border-color',
					'default'   => phast_get_option( 'header-main-rt-section-button-border-color' ),
					'transport' => 'postMessage',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[primary-header-button-border-group]',
					'section'   => 'section-primary-menu',
					'control'   => 'ast-color',
					'priority'  => 12,
					'title'     => __( 'Color', 'phast' ),
				),

				/**
				* Option: Button Border Hover Color
				*/
				array(
					'name'      => 'header-main-rt-section-button-border-h-color',
					'default'   => phast_get_option( 'header-main-rt-section-button-border-h-color' ),
					'transport' => 'postMessage',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[primary-header-button-border-group]',
					'section'   => 'section-primary-menu',
					'control'   => 'ast-color',
					'priority'  => 14,
					'title'     => __( 'Hover Color', 'phast' ),
				),

				/**
				* Option: Button Border Radius
				*/
				array(
					'name'        => 'header-main-rt-section-button-border-radius',
					'default'     => phast_get_option( 'header-main-rt-section-button-border-radius' ),
					'type'        => 'sub-control',
					'parent'      => PHAST_THEME_SETTINGS . '[primary-header-button-border-group]',
					'section'     => 'section-primary-menu',
					'control'     => 'ast-slider',
					'transport'   => 'postMessage',
					'priority'    => 16,
					'title'       => __( 'Border Radius', 'phast' ),
					'input_attrs' => array(
						'min'  => 0,
						'step' => 1,
						'max'  => 100,
					),
				),

				/**
				 * Option: Transparent Header Button Colors Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[transparent-header-button-color-divider]',
					'type'     => 'control',
					'control'  => 'ast-heading',
					'section'  => 'section-transparent-header',
					'title'    => __( 'Header Button', 'phast' ),
					'settings' => array(),
					'priority' => 40,
					'required' => array( PHAST_THEME_SETTINGS . '[header-main-rt-section-button-style]', '===', 'custom-button' ),
				),
				/**
				 * Group: Transparent Header Button Colors Group
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[transparent-header-button-color-group]',
					'default'   => phast_get_option( 'transparent-header-button-color-group' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Colors', 'phast' ),
					'section'   => 'section-transparent-header',
					'transport' => 'postMessage',
					'priority'  => 40,
					'required'  => array( PHAST_THEME_SETTINGS . '[header-main-rt-section-button-style]', '===', 'custom-button' ),
				),
				/**
				 * Group: Transparent Header Button Border Group
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[transparent-header-button-border-group]',
					'default'   => phast_get_option( 'transparent-header-button-border-group' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Border', 'phast' ),
					'section'   => 'section-transparent-header',
					'transport' => 'postMessage',
					'priority'  => 40,
					'required'  => array( PHAST_THEME_SETTINGS . '[header-main-rt-section-button-style]', '===', 'custom-button' ),
				),

				/**
				* Option: Button Text Color
				*/
				array(
					'name'      => 'header-main-rt-trans-section-button-text-color',
					'transport' => 'postMessage',
					'default'   => phast_get_option( 'header-main-rt-trans-section-button-text-color' ),
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[transparent-header-button-color-group]',
					'section'   => 'section-transparent-header',
					'tab'       => __( 'Normal', 'phast' ),
					'control'   => 'ast-color',
					'priority'  => 10,
					'title'     => __( 'Text Color', 'phast' ),
				),

				/**
				* Option: Button Text Hover Color
				*/
				array(
					'name'      => 'header-main-rt-trans-section-button-text-h-color',
					'default'   => phast_get_option( 'header-main-rt-trans-section-button-text-h-color' ),
					'transport' => 'postMessage',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[transparent-header-button-color-group]',
					'section'   => 'section-transparent-header',
					'tab'       => __( 'Hover', 'phast' ),
					'control'   => 'ast-color',
					'priority'  => 10,
					'title'     => __( 'Text Color', 'phast' ),
				),

				/**
				* Option: Button Background Color
				*/
				array(
					'name'      => 'header-main-rt-trans-section-button-back-color',
					'default'   => phast_get_option( 'header-main-rt-trans-section-button-back-color' ),
					'transport' => 'postMessage',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[transparent-header-button-color-group]',
					'section'   => 'section-transparent-header',
					'tab'       => __( 'Normal', 'phast' ),
					'control'   => 'ast-color',
					'priority'  => 10,
					'title'     => __( 'Background Color', 'phast' ),
				),

				/**
				* Option: Button Button Hover Color
				*/
				array(
					'name'      => 'header-main-rt-trans-section-button-back-h-color',
					'default'   => phast_get_option( 'header-main-rt-trans-section-button-back-h-color' ),
					'transport' => 'postMessage',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[transparent-header-button-color-group]',
					'section'   => 'section-transparent-header',
					'tab'       => __( 'Hover', 'phast' ),
					'control'   => 'ast-color',
					'priority'  => 10,
					'title'     => __( 'Background Color', 'phast' ),
				),

				// Option: Custom Menu Button Border.
				array(
					'type'           => 'control',
					'control'        => 'ast-responsive-spacing',
					'name'           => PHAST_THEME_SETTINGS . '[header-main-rt-trans-section-button-padding]',
					'section'        => 'section-transparent-header',
					'transport'      => 'postMessage',
					'linked_choices' => true,
					'priority'       => 40,
					'required'       => array( PHAST_THEME_SETTINGS . '[header-main-rt-section-button-style]', '===', 'custom-button' ),
					'default'        => phast_get_option( 'header-main-rt-trans-section-button-padding' ),
					'title'          => __( 'Padding', 'phast' ),
					'choices'        => array(
						'top'    => __( 'Top', 'phast' ),
						'right'  => __( 'Right', 'phast' ),
						'bottom' => __( 'Bottom', 'phast' ),
						'left'   => __( 'Left', 'phast' ),
					),
				),

				/**
				* Option: Button Border Size
				*/
				array(
					'type'           => 'sub-control',
					'parent'         => PHAST_THEME_SETTINGS . '[transparent-header-button-border-group]',
					'section'        => 'section-transparent-header',
					'control'        => 'ast-border',
					'name'           => 'header-main-rt-trans-section-button-border-size',
					'transport'      => 'postMessage',
					'linked_choices' => true,
					'priority'       => 10,
					'default'        => phast_get_option( 'header-main-rt-trans-section-button-border-size' ),
					'title'          => __( 'Width', 'phast' ),
					'choices'        => array(
						'top'    => __( 'Top', 'phast' ),
						'right'  => __( 'Right', 'phast' ),
						'bottom' => __( 'Bottom', 'phast' ),
						'left'   => __( 'Left', 'phast' ),
					),
				),

				/**
				* Option: Button Border Color
				*/
				array(
					'name'      => 'header-main-rt-trans-section-button-border-color',
					'default'   => phast_get_option( 'header-main-rt-trans-section-button-border-color' ),
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[transparent-header-button-border-group]',
					'section'   => 'section-transparent-header',
					'transport' => 'postMessage',
					'control'   => 'ast-color',
					'priority'  => 12,
					'title'     => __( 'Color', 'phast' ),
				),

				/**
				* Option: Button Border Hover Color
				*/
				array(
					'name'      => 'header-main-rt-trans-section-button-border-h-color',
					'default'   => phast_get_option( 'header-main-rt-trans-section-button-border-h-color' ),
					'transport' => 'postMessage',
					'type'      => 'sub-control',
					'parent'    => PHAST_THEME_SETTINGS . '[transparent-header-button-border-group]',
					'control'   => 'ast-color',
					'priority'  => 14,
					'title'     => __( 'Hover Color', 'phast' ),
				),

				/**
				* Option: Button Border Radius
				*/
				array(
					'name'        => 'header-main-rt-trans-section-button-border-radius',
					'default'     => phast_get_option( 'header-main-rt-trans-section-button-border-radius' ),
					'type'        => 'sub-control',
					'parent'      => PHAST_THEME_SETTINGS . '[transparent-header-button-border-group]',
					'section'     => 'section-transparent-header',
					'control'     => 'ast-slider',
					'transport'   => 'postMessage',
					'priority'    => 16,
					'title'       => __( 'Border Radius', 'phast' ),
					'input_attrs' => array(
						'min'  => 0,
						'step' => 1,
						'max'  => 100,
					),
				),
			);

			return array_merge( $configurations, $_configs );
		}
	}
}

/**
 * Kicking this off by calling 'get_instance()' method
 */
new Phast_Customizer_Button_Configs();
