<?php
/**
 * Styling Options for Phast Theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Adv_Footer_Colors_Configs' ) ) {

	/**
	 * Register Advanced Footer Color Customizer Configurations.
	 */
	class Phast_Advanced_Footer_Colors_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Advanced Footer Color Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {
			$_configs = array(

				/**
				 * Option: Footer Widget Color & Background Section heading
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[footer-widget-color-background-heading-divider]',
					'type'     => 'control',
					'control'  => 'ast-heading',
					'section'  => 'section-footer-adv',
					'title'    => __( 'Colors & Background', 'phast' ),
					'priority' => 46,
					'settings' => array(),
					'required' => array( PHAST_THEME_SETTINGS . '[footer-adv]', '!=', 'disabled' ),
				),

				/**
				 * Option: Footer Bar Content Group
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[footer-widget-background-group]',
					'default'   => phast_get_option( 'footer-widget-background-group' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Background', 'phast' ),
					'section'   => 'section-footer-adv',
					'transport' => 'postMessage',
					'priority'  => 47,
					'required'  => array( PHAST_THEME_SETTINGS . '[footer-adv]', '!=', 'disabled' ),
				),

				/**
				 * Option: Footer Bar Content Group
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[footer-widget-content-group]',
					'default'   => phast_get_option( 'footer-widget-content-group' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Content', 'phast' ),
					'section'   => 'section-footer-adv',
					'transport' => 'postMessage',
					'priority'  => 48,
					'required'  => array( PHAST_THEME_SETTINGS . '[footer-adv]', '!=', 'disabled' ),
				),

				/**
				 * Option: Widget Title Color
				 */
				array(
					'name'    => 'footer-adv-wgt-title-color',
					'type'    => 'sub-control',
					'parent'  => PHAST_THEME_SETTINGS . '[footer-widget-content-group]',
					'section' => 'section-footer-adv',
					'tab'     => __( 'Normal', 'phast' ),
					'control' => 'ast-color',
					'title'   => __( 'Title Color', 'phast' ),
					'default' => '',
				),

				/**
				 * Option: Text Color
				 */
				array(
					'name'    => 'footer-adv-text-color',
					'type'    => 'sub-control',
					'parent'  => PHAST_THEME_SETTINGS . '[footer-widget-content-group]',
					'section' => 'section-footer-adv',
					'tab'     => __( 'Normal', 'phast' ),
					'control' => 'ast-color',
					'title'   => __( 'Text Color', 'phast' ),
					'default' => '',
				),

				/**
				 * Option: Link Color
				 */
				array(
					'name'    => 'footer-adv-link-color',
					'type'    => 'sub-control',
					'parent'  => PHAST_THEME_SETTINGS . '[footer-widget-content-group]',
					'section' => 'section-footer-adv',
					'tab'     => __( 'Normal', 'phast' ),
					'control' => 'ast-color',
					'title'   => __( 'Link Color', 'phast' ),
					'default' => '',
				),

				/**
				 * Option: Link Hover Color
				 */
				array(
					'name'    => 'footer-adv-link-h-color',
					'type'    => 'sub-control',
					'parent'  => PHAST_THEME_SETTINGS . '[footer-widget-content-group]',
					'section' => 'section-footer-adv',
					'tab'     => __( 'Hover', 'phast' ),
					'control' => 'ast-color',
					'title'   => __( 'Link Color', 'phast' ),
					'default' => '',
				),

				/**
				 * Option: Footer widget Background
				 */
				array(
					'name'    => 'footer-adv-bg-obj',
					'type'    => 'sub-control',
					'parent'  => PHAST_THEME_SETTINGS . '[footer-widget-background-group]',
					'section' => 'section-footer-adv',
					'control' => 'ast-background',
					'default' => phast_get_option( 'footer-adv-bg-obj' ),
					'label'   => __( 'Background', 'phast' ),
				),
			);

			$configurations = array_merge( $configurations, $_configs );

			return $configurations;
		}
	}
}

new Phast_Advanced_Footer_Colors_Configs();


