<?php
/**
 * Styling Options for Phast Theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Footer_Colors_Configs' ) ) {

	/**
	 * Register Footer Color Configurations.
	 */
	class Phast_Footer_Colors_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Footer Color Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {
			$_configs = array(

				/**
				 * Option: Color
				 */
				array(
					'name'     => 'footer-color',
					'type'     => 'sub-control',
					'tab'      => __( 'Normal', 'phast' ),
					'priority' => 5,
					'parent'   => PHAST_THEME_SETTINGS . '[footer-bar-content-group]',
					'section'  => 'section-footer-small',
					'control'  => 'ast-color',
					'title'    => __( 'Text Color', 'phast' ),
					'default'  => '',
				),

				/**
				 * Option: Link Color
				 */
				array(
					'name'     => 'footer-link-color',
					'type'     => 'sub-control',
					'tab'      => __( 'Normal', 'phast' ),
					'priority' => 6,
					'parent'   => PHAST_THEME_SETTINGS . '[footer-bar-content-group]',
					'section'  => 'section-footer-small',
					'control'  => 'ast-color',
					'default'  => '',
					'title'    => __( 'Link Color', 'phast' ),
				),

				/**
				 * Option: Link Hover Color
				 */
				array(
					'name'     => 'footer-link-h-color',
					'type'     => 'sub-control',
					'tab'      => __( 'Hover', 'phast' ),
					'priority' => 5,
					'parent'   => PHAST_THEME_SETTINGS . '[footer-bar-content-group]',
					'section'  => 'section-footer-small',
					'control'  => 'ast-color',
					'title'    => __( 'Link Color', 'phast' ),
					'default'  => '',
				),

				/**
				 * Option: Footer Background
				 */
				array(
					'name'      => 'footer-bg-obj',
					'type'      => 'sub-control',
					'priority'  => 7,
					'parent'    => PHAST_THEME_SETTINGS . '[footer-bar-background-group]',
					'section'   => 'section-footer-small',
					'transport' => 'postMessage',
					'control'   => 'ast-background',
					'default'   => phast_get_option( 'footer-bg-obj' ),
					'label'     => __( 'Background', 'phast' ),
				),
			);

			$configurations = array_merge( $configurations, $_configs );

			return $configurations;
		}
	}
}

new Phast_Footer_Colors_Configs();


