<?php
/**
 * Bottom Footer Options for Phast Theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Blog_Layout_Configs' ) ) {

	/**
	 * Register Blog Layout Customizer Configurations.
	 */
	class Phast_Blog_Layout_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Blog Layout Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[ast-styling-section-blog-width]',
					'type'     => 'control',
					'control'  => 'ast-divider',
					'section'  => 'section-blog',
					'priority' => 60,
					'settings' => array(),
				),

				/**
				 * Option: Blog Content Width
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[blog-width]',
					'default'  => phast_get_option( 'blog-width' ),
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'section-blog',
					'priority' => 50,
					'title'    => __( 'Content Width', 'phast' ),
					'choices'  => array(
						'default' => __( 'Default', 'phast' ),
						'custom'  => __( 'Custom', 'phast' ),
					),
				),

				/**
				 * Option: Enter Width
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[blog-max-width]',
					'type'        => 'control',
					'control'     => 'ast-slider',
					'section'     => 'section-blog',
					'transport'   => 'postMessage',
					'default'     => 1200,
					'priority'    => 50,
					'required'    => array( PHAST_THEME_SETTINGS . '[blog-width]', '===', 'custom' ),
					'title'       => __( 'Custom Width', 'phast' ),
					'suffix'      => '',
					'input_attrs' => array(
						'min'  => 768,
						'step' => 1,
						'max'  => 1920,
					),
				),

				/**
				 * Option: Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[ast-styling-section-blog-width-end]',
					'type'     => 'control',
					'control'  => 'ast-divider',
					'section'  => 'section-blog',
					'priority' => 50,
					'settings' => array(),
				),

				/**
				 * Option: Blog Post Content
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[blog-post-content]',
					'section'  => 'section-blog',
					'title'    => __( 'Post Content', 'phast' ),
					'default'  => phast_get_option( 'blog-post-content' ),
					'type'     => 'control',
					'control'  => 'select',
					'priority' => 75,
					'choices'  => array(
						'full-content' => __( 'Full Content', 'phast' ),
						'excerpt'      => __( 'Excerpt', 'phast' ),
					),
				),

				/**
				 * Option: Display Post Structure
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[blog-post-structure]',
					'default'  => phast_get_option( 'blog-post-structure' ),
					'type'     => 'control',
					'control'  => 'ast-sortable',
					'section'  => 'section-blog',
					'priority' => 50,
					'title'    => __( 'Post Structure', 'phast' ),
					'choices'  => array(
						'image'      => __( 'Featured Image', 'phast' ),
						'title-meta' => __( 'Title & Blog Meta', 'phast' ),
					),
				),

				/**
				 * Option: Display Post Meta
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[blog-meta]',
					'type'     => 'control',
					'control'  => 'ast-sortable',
					'section'  => 'section-blog',
					'default'  => phast_get_option( 'blog-meta' ),
					'priority' => 50,
					'required' => array( PHAST_THEME_SETTINGS . '[blog-post-structure]', 'contains', 'title-meta' ),
					'title'    => __( 'Meta', 'phast' ),
					'choices'  => array(
						'comments' => __( 'Comments', 'phast' ),
						'category' => __( 'Category', 'phast' ),
						'author'   => __( 'Author', 'phast' ),
						'date'     => __( 'Publish Date', 'phast' ),
						'tag'      => __( 'Tag', 'phast' ),
					),
				),
			);

			$configurations = array_merge( $configurations, $_configs );

			return $configurations;

		}
	}
}


new Phast_Blog_Layout_Configs();





