<?php
/**
 * Bottom Footer Options for Phast Theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Blog_Single_Layout_Configs' ) ) {

	/**
	 * Register Blog Single Layout Configurations.
	 */
	class Phast_Blog_Single_Layout_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Blog Single Layout Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Single Post Content Width
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[blog-single-width]',
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'section-blog-single',
					'default'  => phast_get_option( 'blog-single-width' ),
					'priority' => 5,
					'title'    => __( 'Content Width', 'phast' ),
					'choices'  => array(
						'default' => __( 'Default', 'phast' ),
						'custom'  => __( 'Custom', 'phast' ),
					),
					'partial'  => array(
						'selector'            => '.ast-single-post .site-content .ast-container .content-area .entry-title',
						'container_inclusive' => false,
					),
				),

				/**
				 * Option: Enter Width
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[blog-single-max-width]',
					'type'        => 'control',
					'control'     => 'ast-slider',
					'section'     => 'section-blog-single',
					'transport'   => 'postMessage',
					'default'     => 1200,
					'required'    => array( PHAST_THEME_SETTINGS . '[blog-single-width]', '===', 'custom' ),
					'priority'    => 5,
					'title'       => __( 'Custom Width', 'phast' ),
					'suffix'      => '',
					'input_attrs' => array(
						'min'  => 768,
						'step' => 1,
						'max'  => 1920,
					),
				),

				/**
				 * Option: Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[ast-styling-section-blog-single-width]',
					'type'     => 'control',
					'control'  => 'ast-divider',
					'section'  => 'section-blog-single',
					'priority' => 5,
					'settings' => array(),
				),

				/**
				 * Option: Display Post Structure
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[blog-single-post-structure]',
					'type'     => 'control',
					'control'  => 'ast-sortable',
					'section'  => 'section-blog-single',
					'default'  => phast_get_option( 'blog-single-post-structure' ),
					'priority' => 5,
					'title'    => __( 'Structure', 'phast' ),
					'choices'  => array(
						'single-image'      => __( 'Featured Image', 'phast' ),
						'single-title-meta' => __( 'Title & Blog Meta', 'phast' ),
					),
				),

				/**
				 * Option: Single Post Meta
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[blog-single-meta]',
					'type'     => 'control',
					'control'  => 'ast-sortable',
					'default'  => phast_get_option( 'blog-single-meta' ),
					'required' => array( PHAST_THEME_SETTINGS . '[blog-single-post-structure]', 'contains', 'single-title-meta' ),
					'section'  => 'section-blog-single',
					'priority' => 5,
					'title'    => __( 'Meta', 'phast' ),
					'choices'  => array(
						'comments' => __( 'Comments', 'phast' ),
						'category' => __( 'Category', 'phast' ),
						'author'   => __( 'Author', 'phast' ),
						'date'     => __( 'Publish Date', 'phast' ),
						'tag'      => __( 'Tag', 'phast' ),
					),
				),
			);

			$configurations = array_merge( $configurations, $_configs );

			return $configurations;

		}
	}
}


new Phast_Blog_Single_Layout_Configs();





