<?php
/**
 * Bottom Footer Options for Phast Theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Sidebar_Layout_Configs' ) ) {

	/**
	 * Register Phast Sidebar Layout Configurations.
	 */
	class Phast_Sidebar_Layout_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Phast Sidebar Layout Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Default Sidebar Position
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[site-sidebar-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'section-sidebars',
					'default'  => phast_get_option( 'site-sidebar-layout' ),
					'priority' => 5,
					'title'    => __( 'Default Layout', 'phast' ),
					'choices'  => array(
						'no-sidebar'    => __( 'No Sidebar', 'phast' ),
						'left-sidebar'  => __( 'Left Sidebar', 'phast' ),
						'right-sidebar' => __( 'Right Sidebar', 'phast' ),
					),
				),

				/**
				 * Option: Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[single-page-sidebar-layout-divider]',
					'type'     => 'control',
					'control'  => 'ast-divider',
					'section'  => 'section-sidebars',
					'priority' => 5,
					'settings' => array(),
				),

				/**
				 * Option: Page
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[single-page-sidebar-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'section-sidebars',
					'default'  => phast_get_option( 'single-page-sidebar-layout' ),
					'priority' => 5,
					'title'    => __( 'Pages', 'phast' ),
					'choices'  => array(
						'default'       => __( 'Default', 'phast' ),
						'no-sidebar'    => __( 'No Sidebar', 'phast' ),
						'left-sidebar'  => __( 'Left Sidebar', 'phast' ),
						'right-sidebar' => __( 'Right Sidebar', 'phast' ),
					),
				),

				/**
				 * Option: Blog Post
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[single-post-sidebar-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'default'  => phast_get_option( 'single-post-sidebar-layout' ),
					'section'  => 'section-sidebars',
					'priority' => 5,
					'title'    => __( 'Blog Posts', 'phast' ),
					'choices'  => array(
						'default'       => __( 'Default', 'phast' ),
						'no-sidebar'    => __( 'No Sidebar', 'phast' ),
						'left-sidebar'  => __( 'Left Sidebar', 'phast' ),
						'right-sidebar' => __( 'Right Sidebar', 'phast' ),
					),
				),

				/**
				 * Option: Blog Post Archive
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[archive-post-sidebar-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'default'  => phast_get_option( 'archive-post-sidebar-layout' ),
					'section'  => 'section-sidebars',
					'priority' => 5,
					'title'    => __( 'Archives', 'phast' ),
					'choices'  => array(
						'default'       => __( 'Default', 'phast' ),
						'no-sidebar'    => __( 'No Sidebar', 'phast' ),
						'left-sidebar'  => __( 'Left Sidebar', 'phast' ),
						'right-sidebar' => __( 'Right Sidebar', 'phast' ),
					),
				),

				/**
				 * Option: Divider
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[divider-section-sidebar-width]',
					'type'     => 'control',
					'section'  => 'section-sidebars',
					'control'  => 'ast-divider',
					'priority' => 10,
					'settings' => array(),
				),

				/**
				 * Option: Primary Content Width
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[site-sidebar-width]',
					'type'        => 'control',
					'control'     => 'ast-slider',
					'default'     => 30,
					'section'     => 'section-sidebars',
					'priority'    => 15,
					'title'       => __( 'Sidebar Width', 'phast' ),
					'suffix'      => '%',
					'input_attrs' => array(
						'min'  => 15,
						'step' => 1,
						'max'  => 50,
					),
				),

				array(
					'name'     => PHAST_THEME_SETTINGS . '[site-sidebar-width-description]',
					'type'     => 'control',
					'control'  => 'ast-description',
					'section'  => 'section-sidebars',
					'priority' => 15,
					'title'    => '',
					'help'     => __( 'Sidebar width will apply only when one of the above sidebar is set.', 'phast' ),
					'settings' => array(),
				),
			);

			return array_merge( $configurations, $_configs );
		}
	}
}


new Phast_Sidebar_Layout_Configs();





