<?php
/**
 * General Options for Phast Theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



if ( ! class_exists( 'Phast_Site_Container_Layout_Configs' ) ) {

	/**
	 * Register Phast Site Container Layout Customizer Configurations.
	 */
	class Phast_Site_Container_Layout_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Phast Site Container Layout Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Divider
				 */

				array(
					'name'     => PHAST_THEME_SETTINGS . '[site-content-layout-divider]',
					'type'     => 'control',
					'control'  => 'ast-divider',
					'section'  => 'section-container-layout',
					'priority' => 50,
					'settings' => array(),
				),

				/**
				 * Option: Single Page Content Layout
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[site-content-layout]',
					'type'     => 'control',
					'default'  => phast_get_option( 'site-content-layout' ),
					'control'  => 'select',
					'section'  => 'section-container-layout',
					'priority' => 50,
					'title'    => __( 'Layout', 'phast' ),
					'choices'  => array(
						'boxed-container'         => __( 'Boxed', 'phast' ),
						'content-boxed-container' => __( 'Content Boxed', 'phast' ),
						'plain-container'         => __( 'Full Width / Contained', 'phast' ),
						'page-builder'            => __( 'Full Width / Stretched', 'phast' ),
					),
				),

				array(
					'name'     => PHAST_THEME_SETTINGS . '[single-page-content-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'default'  => phast_get_option( 'single-page-content-layout' ),
					'section'  => 'section-container-layout',
					'title'    => __( 'Page Layout', 'phast' ),
					'priority' => 55,
					'choices'  => array(
						'default'                 => __( 'Default', 'phast' ),
						'boxed-container'         => __( 'Boxed', 'phast' ),
						'content-boxed-container' => __( 'Content Boxed', 'phast' ),
						'plain-container'         => __( 'Full Width / Contained', 'phast' ),
						'page-builder'            => __( 'Full Width / Stretched', 'phast' ),
					),
				),

				array(
					'name'     => PHAST_THEME_SETTINGS . '[single-post-content-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'default'  => phast_get_option( 'single-post-content-layout' ),
					'section'  => 'section-container-layout',
					'priority' => 60,
					'title'    => __( 'Blog Post Layout', 'phast' ),
					'choices'  => array(
						'default'                 => __( 'Default', 'phast' ),
						'boxed-container'         => __( 'Boxed', 'phast' ),
						'content-boxed-container' => __( 'Content Boxed', 'phast' ),
						'plain-container'         => __( 'Full Width / Contained', 'phast' ),
						'page-builder'            => __( 'Full Width / Stretched', 'phast' ),
					),
				),

				/**
				 * Option: Archive Post Content Layout
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[archive-post-content-layout]',
					'type'     => 'control',
					'control'  => 'select',
					'default'  => phast_get_option( 'archive-post-content-layout' ),
					'section'  => 'section-container-layout',
					'priority' => 65,
					'title'    => __( 'Archives Layout', 'phast' ),
					'choices'  => array(
						'default'                 => __( 'Default', 'phast' ),
						'boxed-container'         => __( 'Boxed', 'phast' ),
						'content-boxed-container' => __( 'Content Boxed', 'phast' ),
						'plain-container'         => __( 'Full Width / Contained', 'phast' ),
						'page-builder'            => __( 'Full Width / Stretched', 'phast' ),
					),
				),

				/**
				 * Option: Body Background
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[site-layout-outside-bg-obj-responsive]',
					'type'      => 'control',
					'control'   => 'ast-responsive-background',
					'default'   => phast_get_option( 'site-layout-outside-bg-obj-responsive' ),
					'section'   => 'section-colors-body',
					'transport' => 'postMessage',
					'priority'  => 25,
					'title'     => __( 'Background', 'phast' ),
				),
			);

			$configurations = array_merge( $configurations, $_configs );

			// Learn More link if Phast Pro is not activated.
			if ( ! defined( 'PHAST_EXT_VER' ) ) {

				$config = array(

					/**
					 * Option: Divider
					 */

					array(
						'name'     => PHAST_THEME_SETTINGS . '[ast-container-more-feature-divider]',
						'type'     => 'control',
						'default'  => phast_get_option( 'site-content-layout' ),
						'control'  => 'ast-divider',
						'section'  => 'section-container-layout',
						'priority' => 999,
						'settings' => array(),
					),

					array(
						'name'     => PHAST_THEME_SETTINGS . '[ast-container-more-feature-description]',
						'type'     => 'control',
						'control'  => 'ast-description',
						'section'  => 'section-container-layout',
						'priority' => 999,
						'title'    => '',
						'help'     => '<p>' . __( 'More Options Available in Phast Pro!', 'phast' ) . '</p><a href="' . phast_get_pro_url( 'https://wpphast.com/pro/', 'customizer', 'learn-more', 'upgrade-to-pro' ) . '" class="button button-secondary"  target="_blank" rel="noopener">' . __( 'Learn More', 'phast' ) . '</a>',
						'settings' => array(),
					),
				);

				$configurations = array_merge( $configurations, $config );
			}

			return $configurations;
		}
	}
}


new Phast_Site_Container_Layout_Configs();




