<?php
/**
 * Styling Options for Phast Theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Archive_Typo_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Archive_Typo_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Archive Typography Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Blog Typography
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[blog-typography-divider]',
					'type'     => 'control',
					'control'  => 'ast-heading',
					'section'  => 'section-blog',
					'title'    => __( 'Typography', 'phast' ),
					'priority' => 135,
					'settings' => array(),
				),

				/**
				 * Option: Blog / Archive Typography
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[blog-content-archive-summary-typo]',
					'default'   => phast_get_option( 'blog-content-archive-summary-typo' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Archive Title', 'phast' ),
					'section'   => 'section-blog',
					'transport' => 'postMessage',
					'priority'  => 140,
				),

				array(
					'name'      => PHAST_THEME_SETTINGS . '[blog-content-blog-post-title-typo]',
					'default'   => phast_get_option( 'blog-content-blog-post-title-typo' ),
					'type'      => 'control',
					'control'   => 'ast-settings-group',
					'title'     => __( 'Post Title', 'phast' ),
					'section'   => 'section-blog',
					'transport' => 'postMessage',
					'priority'  => 140,
				),

				/**
				 * Option: Blog - Post Title Font Size
				 */
				array(
					'name'        => 'font-size-page-title',
					'parent'      => PHAST_THEME_SETTINGS . '[blog-content-blog-post-title-typo]',
					'section'     => 'section-blog',
					'type'        => 'sub-control',
					'control'     => 'ast-responsive',
					'transport'   => 'postMessage',
					'priority'    => 2,
					'default'     => phast_get_option( 'font-size-page-title' ),
					'title'       => __( 'Size', 'phast' ),
					'input_attrs' => array(
						'min' => 0,
					),
					'units'       => array(
						'px' => 'px',
						'em' => 'em',
					),
				),

				/**
				 * Option: Archive Summary Box Title Font Size
				 */
				array(
					'name'        => 'font-size-archive-summary-title',
					'parent'      => PHAST_THEME_SETTINGS . '[blog-content-archive-summary-typo]',
					'section'     => 'section-blog',
					'type'        => 'sub-control',
					'control'     => 'ast-responsive',
					'transport'   => 'postMessage',
					'default'     => phast_get_option( 'font-size-archive-summary-title' ),
					'priority'    => 8,
					'title'       => __( 'Size', 'phast' ),
					'input_attrs' => array(
						'min' => 0,
					),
					'units'       => array(
						'px' => 'px',
						'em' => 'em',
					),
				),
			);

			$configurations = array_merge( $configurations, $_configs );

			// Learn More link if Phast Pro is not activated.
			if ( ! defined( 'PHAST_EXT_VER' ) ) {

				$_configs = array(

					/**
					 * Option: Divider
					 */
					array(
						'name'     => PHAST_THEME_SETTINGS . '[ast-blog-typography-more-feature-divider]',
						'type'     => 'control',
						'control'  => 'ast-divider',
						'section'  => 'section-blog',
						'priority' => 999,
						'settings' => array(),
					),

					/**
					 * Option: Learn More about Contant Typography
					 */
					array(
						'name'     => PHAST_THEME_SETTINGS . '[ast-blog-typography-more-feature-description]',
						'type'     => 'control',
						'control'  => 'ast-description',
						'section'  => 'section-blog',
						'priority' => 999,
						'title'    => '',
						'help'     => '<p>' . __( 'More Options Available in Phast Pro!', 'phast' ) . '</p><a href="' . phast_get_pro_url( 'https://idevsmedia.com/', 'customizer', 'learn-more', 'upgrade-to-pro' ) . '" class="button button-secondary"  target="_blank" rel="noopener">' . __( 'Learn More', 'phast' ) . '</a>',
						'settings' => array(),
					),
				);

				$configurations = array_merge( $configurations, $_configs );
			}

			return $configurations;
		}
	}
}

new Phast_Archive_Typo_Configs();


