<?php
/**
 * Styling Options for Phast Theme.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Phast_Body_Typo_Configs' ) ) {

	/**
	 * Customizer Sanitizes Initial setup
	 */
	class Phast_Body_Typo_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Body Typography Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(

				/**
				 * Option: Body & Content Divider
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[divider-base-typo]',
					'type'      => 'control',
					'control'   => 'ast-heading',
					'section'   => 'section-body-typo',
					'priority'  => 4,
					'title'     => __( 'Body & Content', 'phast' ),
					'settings'  => array(),
					'separator' => false,
				),

				/**
				 * Option: Font Family
				 */

				array(
					'name'        => PHAST_THEME_SETTINGS . '[body-font-family]',
					'type'        => 'control',
					'control'     => 'ast-font',
					'font-type'   => 'ast-font-family',
					'ast_inherit' => __( 'Default System Font', 'phast' ),
					'default'     => phast_get_option( 'body-font-family' ),
					'section'     => 'section-body-typo',
					'priority'    => 5,
					'title'       => __( 'Family', 'phast' ),
					'connect'     => PHAST_THEME_SETTINGS . '[body-font-weight]',
					'variant'     => PHAST_THEME_SETTINGS . '[body-font-variant]',
				),
				/**
				 * Option: Font Variant
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[body-font-variant]',
					'type'              => 'control',
					'control'           => 'ast-font',
					'font-type'         => 'ast-font-variant',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_font_variant' ),
					'default'           => phast_get_option( 'body-font-variant' ),
					'ast_inherit'       => __( 'Default', 'phast' ),
					'section'           => 'section-body-typo',
					'priority'          => 10,
					'title'             => __( 'Variants', 'phast' ),
					'variant'           => PHAST_THEME_SETTINGS . '[body-font-family]',
				),

				/**
				 * Option: Font Weight
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[body-font-weight]',
					'type'              => 'control',
					'control'           => 'ast-font',
					'font-type'         => 'ast-font-weight',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_font_weight' ),
					'default'           => phast_get_option( 'body-font-weight' ),
					'ast_inherit'       => __( 'Default', 'phast' ),
					'section'           => 'section-body-typo',
					'priority'          => 15,
					'title'             => __( 'Weight', 'phast' ),
					'connect'           => PHAST_THEME_SETTINGS . '[body-font-family]',
				),

				/**
				 * Option: Body Text Transform
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[body-text-transform]',
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'section-body-typo',
					'default'  => phast_get_option( 'body-text-transform' ),
					'priority' => 20,
					'title'    => __( 'Text Transform', 'phast' ),
					'choices'  => array(
						''           => __( 'Default', 'phast' ),
						'none'       => __( 'None', 'phast' ),
						'capitalize' => __( 'Capitalize', 'phast' ),
						'uppercase'  => __( 'Uppercase', 'phast' ),
						'lowercase'  => __( 'Lowercase', 'phast' ),
					),
				),

				/**
				 * Option: Body Font Size
				 */
				array(
					'name'        => PHAST_THEME_SETTINGS . '[font-size-body]',
					'type'        => 'control',
					'control'     => 'ast-responsive',
					'section'     => 'section-body-typo',
					'default'     => phast_get_option( 'font-size-body' ),
					'priority'    => 10,
					'title'       => __( 'Size', 'phast' ),
					'input_attrs' => array(
						'min' => 0,
					),
					'units'       => array(
						'px' => 'px',
					),
				),

				/**
				 * Option: Body Line Height
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[body-line-height]',
					'type'              => 'control',
					'control'           => 'ast-slider',
					'section'           => 'section-body-typo',
					'default'           => '',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_number_n_blank' ),
					'priority'          => 25,
					'title'             => __( 'Line Height', 'phast' ),
					'suffix'            => '',
					'input_attrs'       => array(
						'min'  => 1,
						'step' => 0.01,
						'max'  => 5,
					),
				),

				/**
				 * Option: Paragraph Margin Bottom
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[para-margin-bottom]',
					'type'              => 'control',
					'control'           => 'ast-slider',
					'default'           => '',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_number_n_blank' ),
					'transport'         => 'postMessage',
					'section'           => 'section-body-typo',
					'priority'          => 25,
					'title'             => __( 'Paragraph Margin Bottom', 'phast' ),
					'suffix'            => '',
					'input_attrs'       => array(
						'min'  => 0.5,
						'step' => 0.01,
						'max'  => 5,
					),
				),

				/**
				 * Option: Body & Content Divider
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[divider-headings-typo]',
					'type'      => 'control',
					'control'   => 'ast-heading',
					'section'   => 'section-content-typo',
					'priority'  => 3,
					'title'     => __( 'Headings ( H1 - H6 )', 'phast' ),
					'settings'  => array(),
					'separator' => false,
				),

				/**
				 * Option: Headings Font Family
				 */
				array(
					'name'      => PHAST_THEME_SETTINGS . '[headings-font-family]',
					'type'      => 'control',
					'control'   => 'ast-font',
					'font-type' => 'ast-font-family',
					'default'   => phast_get_option( 'headings-font-family' ),
					'title'     => __( 'Family', 'phast' ),
					'section'   => 'section-content-typo',
					'priority'  => 3,
					'connect'   => PHAST_THEME_SETTINGS . '[headings-font-weight]',
					'variant'   => PHAST_THEME_SETTINGS . '[headings-font-variant]',
				),

				/**
				 * Option: Font Variant
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[headings-font-variant]',
					'type'              => 'control',
					'control'           => 'ast-font',
					'font-type'         => 'ast-font-variant',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_font_variant' ),
					'default'           => phast_get_option( 'headings-font-variant' ),
					'ast_inherit'       => __( 'Default', 'phast' ),
					'section'           => 'section-content-typo',
					'priority'          => 3,
					'title'             => __( 'Variants', 'phast' ),
					'variant'           => PHAST_THEME_SETTINGS . '[headings-font-family]',
				),

				/**
				 * Option: Headings Font Weight
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[headings-font-weight]',
					'type'              => 'control',
					'control'           => 'ast-font',
					'font-type'         => 'ast-font-weight',
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_font_weight' ),
					'default'           => phast_get_option( 'headings-font-weight' ),
					'title'             => __( 'Weight', 'phast' ),
					'section'           => 'section-content-typo',
					'priority'          => 3,
					'connect'           => PHAST_THEME_SETTINGS . '[headings-font-family]',
				),

				/**
				 * Option: Headings Text Transform
				 */
				array(
					'name'     => PHAST_THEME_SETTINGS . '[headings-text-transform]',
					'type'     => 'control',
					'control'  => 'select',
					'section'  => 'section-content-typo',
					'title'    => __( 'Text Transform', 'phast' ),
					'default'  => phast_get_option( 'headings-text-transform' ),
					'priority' => 3,
					'choices'  => array(
						''           => __( 'Inherit', 'phast' ),
						'none'       => __( 'None', 'phast' ),
						'capitalize' => __( 'Capitalize', 'phast' ),
						'uppercase'  => __( 'Uppercase', 'phast' ),
						'lowercase'  => __( 'Lowercase', 'phast' ),
					),
				),

				/**
				 * Option: Heading <H1> Line Height
				 */
				array(
					'name'              => PHAST_THEME_SETTINGS . '[headings-line-height]',
					'section'           => 'section-content-typo',
					'default'           => phast_get_option( 'headings-line-height' ),
					'sanitize_callback' => array( 'Phast_Customizer_Sanitizes', 'sanitize_number_n_blank' ),
					'type'              => 'control',
					'control'           => 'ast-slider',
					'title'             => __( 'Line Height', 'phast' ),
					'transport'         => 'postMessage',
					'priority'          => 4,
					'suffix'            => '',
					'input_attrs'       => array(
						'min'  => 1,
						'step' => 0.01,
						'max'  => 5,
					),
					'section'           => 'section-content-typo',
					'transport'         => 'postMessage',
				),
			);

			return array_merge( $configurations, $_configs );
		}
	}
}

new Phast_Body_Typo_Configs();


