<?php
/**
 * Register customizer Aspra Pro Section.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.13
 */

if ( ! class_exists( 'Phast_Pro_Upgrade_Link_Configs' ) ) {

	/**
	 * Register Button Customizer Configurations.
	 */
	class Phast_Pro_Upgrade_Link_Configs extends Phast_Customizer_Config_Base {

		/**
		 * Register Button Customizer Configurations.
		 *
		 * @param Array                $configurations Phast Customizer Configurations.
		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.
		 * @since 1.4.3
		 * @return Array Phast Customizer Configurations with updated configurations.
		 */
		public function register_configuration( $configurations, $wp_customize ) {

			$_configs = array(
				array(
					'name'             => 'phast-pro',
					'type'             => 'section',
					'title'            => esc_html__( 'More Options Available in Phast Pro!', 'phast' ),
					'pro_url'          => htmlspecialchars_decode( phast_get_pro_url( 'https://idevsmedia.com/phast/', 'customizer', 'upgrade-link', 'upgrade-to-pro' ) ),
					'priority'         => 1,
					'section_callback' => 'Phast_Pro_Customizer',
				),
			);

			return array_merge( $configurations, $_configs );

		}
	}
}

new Phast_Pro_Upgrade_Link_Configs();

