<?php
/**
 * Schema markup.
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 2.1.3
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Phast Schema Markup.
 *
 * @since 2.1.3
 */
class Phast_Schema {

	/**
	 * Constructor
	 */
	public function __construct() {
		$this->include_schemas();

		add_action( 'wp', array( $this, 'setup_schema' ) );
	}

	/**
	 * Setup schema
	 *
	 * @since 2.1.3
	 */
	public function setup_schema() { }

	/**
	 * Include schema files.
	 *
	 * @since 2.1.3
	 */
	private function include_schemas() {
		// @codingStandardsIgnoreStart WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
		require_once PHAST_THEME_DIR . 'inc/schema/class-phast-creativework-schema.php';
		require_once PHAST_THEME_DIR . 'inc/schema/class-phast-wpheader-schema.php';
		require_once PHAST_THEME_DIR . 'inc/schema/class-phast-wpfooter-schema.php';
		require_once PHAST_THEME_DIR . 'inc/schema/class-phast-wpsidebar-schema.php';
		require_once PHAST_THEME_DIR . 'inc/schema/class-phast-person-schema.php';
		require_once PHAST_THEME_DIR . 'inc/schema/class-phast-organization-schema.php';
		require_once PHAST_THEME_DIR . 'inc/schema/class-phast-site-navigation-schema.php';
		require_once PHAST_THEME_DIR . 'inc/schema/class-phast-breadcrumb-schema.php';
		// @codingStandardsIgnoreEnd WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
	}

	/**
	 * Enabled schema
	 *
	 * @since 2.1.3
	 */
	protected function schema_enabled() {
		return apply_filters( 'phast_schema_enabled', true );
	}

}

new Phast_Schema();
