<?php
/**
 * Template for Single post
 *
 * @package     Phast
 * @author      Phast
 * @copyright   Copyright (c) 2020, Phast
 * @link        https://idevsmedia.com/
 * @since       Phast 1.0.0
 */

?>

<div <?php phast_blog_layout_class( 'single-layout-1' ); ?>>

	<?php phast_single_header_before(); ?>

	<header class="entry-header <?php phast_entry_header_class(); ?>">

		<?php phast_single_header_top(); ?>

		<?php phast_blog_post_thumbnail_and_title_order(); ?>

		<?php phast_single_header_bottom(); ?>

	</header><!-- .entry-header -->

	<?php phast_single_header_after(); ?>

	<div class="entry-content clear" 
	<?php
				echo phast_attr(
					'article-entry-content-single-layout',
					array(
						'class' => '',
					)
				);
				?>
	>

		<?php phast_entry_content_before(); ?>

		<?php the_content(); ?>

		<?php
			phast_edit_post_link(
				sprintf(
					/* translators: %s: Name of current post */
					esc_html__( 'Edit %s', 'phast' ),
					the_title( '<span class="screen-reader-text">"', '"</span>', false )
				),
				'<span class="edit-link">',
				'</span>'
			);
			?>

		<?php phast_entry_content_after(); ?>

		<?php
			wp_link_pages(
				array(
					'before'      => '<div class="page-links">' . esc_html( phast_default_strings( 'string-single-page-links-before', false ) ),
					'after'       => '</div>',
					'link_before' => '<span class="page-link">',
					'link_after'  => '</span>',
				)
			);
			?>
	</div><!-- .entry-content .clear -->
</div>
